/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class UnsupportedTemporalUnitException
extends CypherTypeException {
    private UnsupportedTemporalUnitException(ErrorGqlStatusObject gqlStatusObject, String errorMsg) {
        super(gqlStatusObject, errorMsg);
    }

    private UnsupportedTemporalUnitException(ErrorGqlStatusObject gqlStatusObject, String errorMsg, Throwable cause) {
        super(gqlStatusObject, errorMsg, cause);
    }

    public static UnsupportedTemporalUnitException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new UnsupportedTemporalUnitException(gql, message);
    }

    public static UnsupportedTemporalUnitException cannotProcess(String value, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N11).withParam(GqlParams.StringParam.input, value).build()).build();
        return new UnsupportedTemporalUnitException(gql, e.getMessage(), e);
    }

    public static UnsupportedTemporalUnitException cannotSelectDatetime(String dateTime) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)"ZONED DATETIME", (String)dateTime);
        return new UnsupportedTemporalUnitException(gql, "Cannot select datetime from: " + dateTime);
    }

    public static UnsupportedTemporalUnitException tooSmallUnitForTruncate(String unit, String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)unit, (String)value);
        return new UnsupportedTemporalUnitException(gql, "Unit too small for truncation: " + unit);
    }

    public static UnsupportedTemporalUnitException cannotGetLocalTime(String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)"LOCAL TIME", (String)value);
        return new UnsupportedTemporalUnitException(gql, String.format("Cannot get the time of: %s", value));
    }

    public static UnsupportedTemporalUnitException cannotGetZonedTime(String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)"ZONED TIME", (String)value);
        return new UnsupportedTemporalUnitException(gql, String.format("Cannot get the time of: %s", value));
    }

    public static UnsupportedTemporalUnitException cannotGetTimezone(String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)"ZONED TIME/ZONED DATETIME", (String)value);
        return new UnsupportedTemporalUnitException(gql, String.format("Cannot get the time zone of: %s", value));
    }

    public static UnsupportedTemporalUnitException cannotGetDate(String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)"DATE", (String)value);
        return new UnsupportedTemporalUnitException(gql, String.format("Cannot get the date of: %s", value));
    }

    public static UnsupportedTemporalUnitException cannotTruncateWithTimeBasedUnit(String input, String type, String prettifiedType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)prettifiedType, (String)input);
        return new UnsupportedTemporalUnitException(gql, String.format("Cannot truncate %s to %s with a time based unit.", input, type));
    }

    public static UnsupportedTemporalUnitException cannotGetZoneOffset(String input) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)"ZONED TIME/ZONED DATETIME", (String)input);
        return new UnsupportedTemporalUnitException(gql, String.format("Cannot get the offset of: %s", input));
    }

    public static UnsupportedTemporalUnitException noSuchField(String fieldName, String fieldType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)fieldName, (String)fieldType);
        return new UnsupportedTemporalUnitException(gql, String.format("No such field: %s", fieldName));
    }

    public static UnsupportedTemporalUnitException epochNotSupported(String component, String temporal) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N15((String)component, (String)temporal);
        return new UnsupportedTemporalUnitException(gql, "Epoch not supported.");
    }

    public static UnsupportedTemporalUnitException notSupported(String component, String valueType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N40((String)component, (String)valueType);
        return new UnsupportedTemporalUnitException(gql, "Not supported: " + component);
    }

    public static UnsupportedTemporalUnitException cannotAssignTimezone(String component, String valueType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N40((String)component, (String)valueType);
        return new UnsupportedTemporalUnitException(gql, "Cannot assign time zone if also assigning other fields.");
    }

    public static UnsupportedTemporalUnitException cannotAssignToCalendarDate(String component) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N40((String)component, (String)"calendar date");
        return new UnsupportedTemporalUnitException(gql, "Cannot assign " + component + " to calendar date.");
    }

    public static UnsupportedTemporalUnitException cannotAssignToWeekDate(String component) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N40((String)component, (String)"week date");
        return new UnsupportedTemporalUnitException(gql, "Cannot assign " + component + " to week date.");
    }

    public static UnsupportedTemporalUnitException cannotAssignToQuarterDate(String component) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N40((String)component, (String)"quarter date");
        return new UnsupportedTemporalUnitException(gql, "Cannot assign " + component + " to quarter date.");
    }

    public static UnsupportedTemporalUnitException cannotAssignToOrdinalDate(String component) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G05_22N40((String)component, (String)"ordinal date");
        return new UnsupportedTemporalUnitException(gql, "Cannot assign " + component + " to ordinal date.");
    }
}

