/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.kernel.api.exceptions.Status;

public class MergeConstraintConflictException
extends Neo4jException {
    public MergeConstraintConflictException(String message) {
        super(message);
    }

    public Status status() {
        return Status.Schema.ConstraintValidationFailed;
    }

    public static <T> T nodeConflict(String node) {
        throw new MergeConstraintConflictException(String.format("Merge did not find a matching node %s and can not create a new node due to conflicts with existing unique nodes", node));
    }

    public static <T> T relationshipConflict(String relationship) {
        throw new MergeConstraintConflictException(String.format("Merge did not find a matching relationship %s and can not create a new relationship due to conflicts with existing unique relationships", relationship));
    }
}

