/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class DatabaseAdministrationOnFollowerException
extends CypherExecutionException {
    private static final String FOLLOWER_ERROR = "Administration commands must be executed on the LEADER server.";

    private DatabaseAdministrationOnFollowerException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    public static DatabaseAdministrationOnFollowerException notALeader(String command, String startOfLegacyMessage, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N29).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.cmd, command).build();
        return new DatabaseAdministrationOnFollowerException(gql, String.format("%s: %s", startOfLegacyMessage, FOLLOWER_ERROR), cause);
    }

    @Override
    public Status status() {
        return Status.Cluster.NotALeader;
    }
}

