/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class InvalidArgumentException
extends Neo4jException {
    @Deprecated
    public InvalidArgumentException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidArgumentException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    @Deprecated
    public InvalidArgumentException(String message) {
        super(message);
    }

    public InvalidArgumentException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public Status status() {
        return Status.Statement.ArgumentError;
    }

    public static InvalidArgumentException unknownNormalForm(String normalForm) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N49).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.input, normalForm).build()).build();
        return new InvalidArgumentException(gql, "Unknown normal form. Valid values are: NFC, NFD, NFKC, NFKD.");
    }

    public static InvalidArgumentException incompleteSpatialValue(String crs, String mandatoryKeys, List<String> mandatoryKeysList) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N18).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.crs, String.valueOf(crs)).withParam(GqlParams.ListParam.mapKeyList, mandatoryKeysList).build()).build();
        return new InvalidArgumentException(gql, String.format("A %s point must contain %s", crs, mandatoryKeys));
    }

    public static InvalidArgumentException invalidSpatialValueCombination() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N22).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build()).build();
        return new InvalidArgumentException(gql, "Cannot specify both CRS and SRID");
    }

    public static InvalidArgumentException timezoneAndOffsetMismatch(String zoneName, String offset, List<String> validOffsets, String matcherGroup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N04).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.input, zoneName).withParam(GqlParams.StringParam.context, String.valueOf(offset)).withParam(GqlParams.ListParam.inputList, validOffsets).build()).build();
        return new InvalidArgumentException(gql, "Timezone and offset do not match: " + matcherGroup);
    }

    public static InvalidArgumentException temporalSelectionConflict(String fieldName, String component) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22007).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N14).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.temporal, fieldName).withParam(GqlParams.StringParam.component, component).build()).build();
        throw new InvalidArgumentException(gql, String.format("%s cannot be selected together with %s.", fieldName, component));
    }

    public static InvalidArgumentException invalidCoordinateNames() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N19).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build()).build();
        return new InvalidArgumentException(gql, "A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
    }

    public static InvalidArgumentException pointWithWrongDimensions(int expectedDimension, int actualDimension) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N20).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.NumberParam.dim1, (Number)expectedDimension).withParam(GqlParams.NumberParam.value, (Number)actualDimension).withParam(GqlParams.NumberParam.dim2, (Number)actualDimension).build()).build();
        return new InvalidArgumentException(gql, String.format("Cannot create point with %dD coordinate reference system and %d coordinates. Please consider using equivalent %dD coordinate reference system", expectedDimension, actualDimension, actualDimension));
    }

    public static InvalidArgumentException bothAllowedAndDeniedDbs() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N85).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidArgumentException(gql, "Can't specify both allowed and denied databases");
    }
}

