/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class MergeConstraintConflictException
extends Neo4jException {
    private MergeConstraintConflictException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public Status status() {
        return Status.Schema.ConstraintValidationFailed;
    }

    public static MergeConstraintConflictException nodeConflict(String node) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G12).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N41).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.variable, node).build()).build();
        return new MergeConstraintConflictException(gql, String.format("Merge did not find a matching node %s and can not create a new node due to conflicts with existing unique nodes", node));
    }

    public static MergeConstraintConflictException relationshipConflict(String relationship) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G12).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N42).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.variable, relationship).build()).build();
        return new MergeConstraintConflictException(gql, String.format("Merge did not find a matching relationship %s and can not create a new relationship due to conflicts with existing unique relationships", relationship));
    }
}

