/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class FabricDatabaseManager {
    protected final FabricConfig fabricConfig;
    protected final DatabaseReferenceRepository databaseReferenceRepo;
    protected final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;

    public FabricDatabaseManager(FabricConfig fabricConfig, DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, DatabaseReferenceRepository databaseReferenceRepo) {
        this.fabricConfig = fabricConfig;
        this.databaseContextProvider = databaseContextProvider;
        this.databaseReferenceRepo = databaseReferenceRepo;
    }

    public DatabaseReferenceRepository databaseReferenceRepository() {
        return this.databaseReferenceRepo;
    }

    public DatabaseReference getDatabaseReference(String databaseNameRaw) {
        return (DatabaseReference)this.databaseReferenceRepo.getByAlias(databaseNameRaw).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
    }

    public GraphDatabaseAPI getDatabaseFacade(String databaseNameRaw) throws UnavailableException {
        DatabaseContext databaseContext = this.getDatabaseContext(databaseNameRaw);
        databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        return databaseContext.databaseFacade();
    }

    private DatabaseContext getDatabaseContext(String databaseNameRaw) throws UnavailableException {
        DatabaseReference databaseReference = (DatabaseReference)this.databaseReferenceRepo.getByAlias(databaseNameRaw).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
        return this.getDatabaseContext(databaseReference).orElseThrow(() -> UnavailableException.databaseUnavailable((String)databaseNameRaw));
    }

    private Optional<? extends DatabaseContext> getDatabaseContext(DatabaseReference databaseReference) {
        DatabaseReference databaseReference2 = databaseReference;
        Objects.requireNonNull(databaseReference2);
        DatabaseReference databaseReference3 = databaseReference2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DatabaseReferenceImpl.Composite.class, DatabaseReferenceImpl.Internal.class}, (Object)databaseReference3, n)) {
            case 0 -> {
                DatabaseReferenceImpl.Composite composite = (DatabaseReferenceImpl.Composite)databaseReference3;
                yield this.databaseContextProvider.getDatabaseContext(composite.databaseId());
            }
            case 1 -> {
                DatabaseReferenceImpl.Internal internal = (DatabaseReferenceImpl.Internal)databaseReference3;
                yield this.databaseContextProvider.getDatabaseContext(internal.databaseId());
            }
            default -> Optional.empty();
        };
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> DatabaseNotFoundHelper.databaseNameNotFoundWithoutDot((String)databaseNameRaw);
    }

    public boolean isFabricDatabase(NamedDatabaseId databaseId2) {
        return false;
    }

    public FabricConfig getFabricConfig() {
        return this.fabricConfig;
    }
}

