/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.compiler.helpers.SignatureResolver;
import org.neo4j.cypher.internal.evaluator.StaticEvaluation;
import org.neo4j.cypher.internal.frontend.phases.InternalSyntaxUsageStats;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignatureResolver;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.ApplyExecutor;
import org.neo4j.fabric.executor.CallInTransactionsExecutor;
import org.neo4j.fabric.executor.EffectiveQueryType;
import org.neo4j.fabric.executor.FabricExecutorResult;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.RemoteBatchExecutor;
import org.neo4j.fabric.executor.SingleQueryFragmentExecutor;
import org.neo4j.fabric.executor.StandardQueryExecutor;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.stream.DelegatingFragmentResult;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.StatementResults;
import org.neo4j.fabric.stream.summary.MergedSummary;
import org.neo4j.fabric.stream.summary.PlanlessSummary;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.notifications.NotificationImplementation;
import org.neo4j.notifications.StandardGqlStatusObject;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

public class FabricExecutor {
    public static final String WRITING_IN_READ_NOT_ALLOWED_MSG = "Writing in read access mode not allowed";
    private final FabricConfig.DataStream dataStreamConfig;
    private final FabricPlanner planner;
    private final UseEvaluation useEvaluation;
    private final InternalLog log;
    private final QueryStatementLifecycles statementLifecycles;
    private final CallableExecutor fabricWorkerExecutor;
    private final QueryRoutingMonitor queryRoutingMonitor;
    private final InternalSyntaxUsageStats internalSyntaxUsageStats;

    public FabricExecutor(FabricConfig config, FabricPlanner planner, UseEvaluation useEvaluation, InternalLogProvider internalLog, QueryStatementLifecycles statementLifecycles, CallableExecutor fabricWorkerExecutor, Monitors monitors, InternalSyntaxUsageStats internalSyntaxUsageStats) {
        this.dataStreamConfig = config.getDataStream();
        this.planner = planner;
        this.useEvaluation = useEvaluation;
        this.log = internalLog.getLog(this.getClass());
        this.statementLifecycles = statementLifecycles;
        this.fabricWorkerExecutor = fabricWorkerExecutor;
        this.queryRoutingMonitor = (QueryRoutingMonitor)monitors.newMonitor(QueryRoutingMonitor.class, new String[0]);
        this.internalSyntaxUsageStats = internalSyntaxUsageStats;
    }

    public StatementResult run(FabricTransaction fabricTransaction, String statement, MapValue parameters) {
        ExecutingQuery.TransactionBinding transactionBinding = fabricTransaction.transactionBinding();
        QueryStatementLifecycles.StatementLifecycle lifecycle = this.statementLifecycles.create(fabricTransaction.getTransactionInfo(), statement, parameters, transactionBinding);
        lifecycle.startProcessing();
        Procedures procedures = fabricTransaction.contextlessProcedures();
        ProcedureSignatureResolver signatureResolver = SignatureResolver.from((Procedures)procedures);
        StaticEvaluation.StaticEvaluator evaluator = StaticEvaluation.from((Procedures)procedures);
        try {
            DatabaseReference defaultGraphName = fabricTransaction.getTransactionInfo().getSessionDatabaseReference();
            Catalog catalog = fabricTransaction.getCatalogSnapshot();
            FabricPlanner.PlannerInstance plannerInstance = this.planner.instance(signatureResolver, statement, parameters, defaultGraphName, catalog, this.internalSyntaxUsageStats, fabricTransaction.cancellationChecker());
            lifecycle.donePreParsing(plannerInstance.query());
            FabricPlan plan = plannerInstance.plan();
            Fragment query = plan.query();
            lifecycle.doneFabricProcessing(plan, plannerInstance.query().options().offset().offset());
            AccessMode accessMode = fabricTransaction.getTransactionInfo().getAccessMode();
            if (plan.debugOptions().logPlan()) {
                this.log.debug(String.format("Fabric plan: %s", Fragment.pretty().asString(query)));
            }
            StatementResult statementResult = fabricTransaction.execute(ctx -> {
                UseEvaluation.Instance useEvaluator = this.useEvaluation.instance(evaluator, plannerInstance.signatureResolver(), statement, catalog);
                FabricStatementExecution execution = plan.debugOptions().logRecords() ? new FabricLoggingStatementExecution(this, plan, plannerInstance, useEvaluator, parameters, accessMode, (FabricTransaction.FabricExecutionContext)ctx, this.log, lifecycle, this.dataStreamConfig, fabricTransaction.getTransactionInfo().getQueryExecutionConfiguration().notificationFilters()) : new FabricStatementExecution(plan, plannerInstance, useEvaluator, parameters, accessMode, (FabricTransaction.FabricExecutionContext)ctx, lifecycle, this.dataStreamConfig, fabricTransaction.getTransactionInfo().getQueryExecutionConfiguration().notificationFilters());
                return execution.run();
            });
            return statementResult;
        }
        catch (RuntimeException e) {
            lifecycle.endFailure(e);
            throw e;
        }
    }

    public long clearQueryCachesForDatabase(String databaseName) {
        return this.planner.queryCache().clearByContext(databaseName);
    }

    private class FabricLoggingStatementExecution
    extends FabricStatementExecution {
        private final AtomicInteger step = new AtomicInteger(0);
        private final InternalLog log;

        FabricLoggingStatementExecution(FabricExecutor fabricExecutor, FabricPlan plan, FabricPlanner.PlannerInstance plannerInstance, UseEvaluation.Instance useEvaluator, MapValue params, AccessMode accessMode, FabricTransaction.FabricExecutionContext ctx, InternalLog log, QueryStatementLifecycles.StatementLifecycle lifecycle, FabricConfig.DataStream dataStreamConfig, NotificationConfiguration notificationConfiguration) {
            super(plan, plannerInstance, useEvaluator, params, accessMode, ctx, lifecycle, dataStreamConfig, notificationConfiguration);
            this.log = log;
        }

        @Override
        SingleQueryFragmentExecutor.Tracer tracer() {
            return new SingleQueryFragmentExecutor.Tracer(){

                @Override
                public SingleQueryFragmentExecutor.RecordTracer remoteQueryStart(Location.Remote location, String queryString) {
                    String id = FabricLoggingStatementExecution.this.executionId();
                    FabricLoggingStatementExecution.this.trace(id, "remote " + FabricLoggingStatementExecution.nameString(location), FabricLoggingStatementExecution.this.compact(queryString));
                    return fragmentResult -> FabricLoggingStatementExecution.this.doTraceRecords(id, fragmentResult);
                }

                @Override
                public SingleQueryFragmentExecutor.RecordTracer localQueryStart(Location.Local location, FullyParsedQuery query) {
                    String id = FabricLoggingStatementExecution.this.executionId();
                    FabricLoggingStatementExecution.this.trace(id, "local " + FabricLoggingStatementExecution.nameString(location), FabricLoggingStatementExecution.this.compact(query.description()));
                    return fragmentResult -> FabricLoggingStatementExecution.this.doTraceRecords(id, fragmentResult);
                }
            };
        }

        private static String nameString(Location location) {
            Stream<String> namespace = location.databaseReference().namespace().map(NormalizedDatabaseName::name).stream();
            Stream<String> name = Stream.of(location.databaseReference().alias().name());
            return Stream.concat(namespace, name).collect(Collectors.joining("."));
        }

        private String compact(String in) {
            return in.replaceAll("\\r?\\n", " ").replaceAll("\\s+", " ");
        }

        private FragmentResult doTraceRecords(final String id, FragmentResult fragmentResult) {
            return new DelegatingFragmentResult(fragmentResult){
                boolean completed;
                {
                    super(delegate);
                    this.completed = false;
                }

                @Override
                public Record next() {
                    Record record;
                    try {
                        record = super.next();
                    }
                    catch (RuntimeException e) {
                        String rec = e.getClass().getSimpleName() + ": " + e.getMessage();
                        FabricLoggingStatementExecution.this.trace(id, "error", rec);
                        throw e;
                    }
                    if (record == null) {
                        this.completed = true;
                        FabricLoggingStatementExecution.this.trace(id, "complete", "complete");
                    } else {
                        String rec = IntStream.range(0, record.size()).mapToObj(i -> record.getValue(i).toString()).collect(Collectors.joining(", ", "[", "]"));
                        FabricLoggingStatementExecution.this.trace(id, "output", rec);
                    }
                    return record;
                }

                @Override
                public PlanlessSummary consume() {
                    if (!this.completed) {
                        FabricLoggingStatementExecution.this.trace(id, "cancel", "cancel");
                    }
                    return this.delegate.consume();
                }
            };
        }

        private void trace(String id, String event, String data) {
            this.log.debug(String.format("%s: %s: %s", id, event, data));
        }

        private String executionId() {
            String stmtId = this.idString(this.hashCode());
            String step = this.idString(this.step.getAndIncrement());
            return String.format("%s/%s", stmtId, step);
        }

        private String idString(int code) {
            return String.format("%08X", code);
        }
    }

    private class FabricStatementExecution {
        private final FabricPlan plan;
        private final FabricPlanner.PlannerInstance plannerInstance;
        private final UseEvaluation.Instance useEvaluator;
        private final MapValue queryParams;
        private final FabricTransaction.FabricExecutionContext ctx;
        private final java.util.List<NotificationImplementation> planNotifications;
        private final QueryStatementLifecycles.StatementLifecycle lifecycle;
        private final AccessMode accessMode;

        FabricStatementExecution(FabricPlan plan, FabricPlanner.PlannerInstance plannerInstance, UseEvaluation.Instance useEvaluator, MapValue queryParams, AccessMode accessMode, FabricTransaction.FabricExecutionContext ctx, QueryStatementLifecycles.StatementLifecycle lifecycle, FabricConfig.DataStream dataStreamConfig, NotificationConfiguration notificationConfiguration) {
            this.plan = plan;
            this.plannerInstance = plannerInstance;
            this.useEvaluator = useEvaluator;
            this.queryParams = queryParams;
            this.ctx = ctx;
            this.lifecycle = lifecycle;
            this.accessMode = accessMode;
            List filteredNotifications = ((Iterable)plan.notifications().filter(arg_0 -> ((NotificationConfiguration)notificationConfiguration).includes(arg_0))).toList();
            this.planNotifications = CollectionConverters.asJava((Seq)filteredNotifications);
        }

        StatementResult run() {
            this.lifecycle.startExecution(false);
            Fragment query = this.plan.query();
            if (this.plan.executionType() == FabricPlan.EXPLAIN() && this.plan.inCompositeContext()) {
                this.lifecycle.endSuccess();
                HashSet<NotificationImplementation> gqlStatusObjects = new HashSet<NotificationImplementation>(this.planNotifications);
                gqlStatusObjects.add((NotificationImplementation)StandardGqlStatusObject.OMITTED_RESULT);
                return StatementResults.emptyStream(CollectionConverters.asJava(query.outputColumns()), new MergedSummary(this.plan.query().description(), QueryStatistics.EMPTY, new HashSet<NotificationImplementation>(this.planNotifications), gqlStatusObjects), EffectiveQueryType.queryExecutionType(this.plan, this.accessMode));
            }
            FragmentResult fragmentResult = this.run(query, null);
            return new FabricExecutorResult(fragmentResult, this.planNotifications, query.producesResults(), this.lifecycle);
        }

        private FragmentResult run(Fragment fragment, Record argument) {
            Fragment fragment2 = fragment;
            Objects.requireNonNull(fragment2);
            Fragment fragment3 = fragment2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Fragment.Init.class, Fragment.Apply.class, Fragment.Union.class, Fragment.Exec.class}, (Object)fragment3, n)) {
                case 0 -> {
                    Fragment.Init init = (Fragment.Init)fragment3;
                    yield this.runInit();
                }
                case 1 -> {
                    Fragment.Apply apply = (Fragment.Apply)fragment3;
                    if (apply.inTransactionsParameters().isEmpty()) {
                        yield this.runApply(apply, argument);
                    }
                    yield this.runCallInTransactions(apply, argument);
                }
                case 2 -> {
                    Fragment.Union union = (Fragment.Union)fragment3;
                    yield this.runUnion(union, argument);
                }
                case 3 -> {
                    Fragment.Exec exec = (Fragment.Exec)fragment3;
                    yield this.runExec(exec, argument);
                }
                default -> throw this.notImplemented("Invalid query fragment", fragment);
            };
        }

        private FragmentResult runInit() {
            return StatementResults.oneRecord(java.util.List.of(), Records.empty(), null);
        }

        private FragmentResult runApply(Fragment.Apply apply, Record argument) {
            QueryExecutionType queryExecutionType = EffectiveQueryType.queryExecutionType(this.plan, this.accessMode);
            FragmentResult input = this.run(apply.input(), argument);
            RemoteBatchExecutor remoteBatchExecutor = new RemoteBatchExecutor(FabricExecutor.this.fabricWorkerExecutor, record -> this.run(apply.inner(), (Record)record), 1000, 10);
            return new ApplyExecutor(CollectionConverters.asJava(apply.outputColumns()), input, apply.inner().outputColumns().isEmpty(), queryExecutionType, remoteBatchExecutor, record -> this.run(apply.inner(), (Record)record), record -> this.isRemoteFragment(apply.inner(), (Record)record));
        }

        private boolean isRemoteFragment(Fragment fragment, Record argument) {
            if (fragment instanceof Fragment.Exec) {
                Fragment.Exec exec = (Fragment.Exec)fragment;
                Map<String, AnyValue> argumentValues = SingleQueryFragmentExecutor.argumentValues(fragment, argument);
                Catalog.Graph graph = this.useEvaluator.evaluate(exec.use().graphSelection(), this.queryParams, argumentValues, this.ctx.getSessionDatabaseReference()).graph();
                TransactionMode transactionMode = SingleQueryFragmentExecutor.getTransactionMode(this.plan, this.accessMode, exec.queryType(), graph.reference().toPrettyString());
                Location location = this.ctx.locationOf(graph, transactionMode.requiresWrite());
                return location instanceof Location.Remote;
            }
            return false;
        }

        private FragmentResult runUnion(Fragment.Union union, Record argument) {
            FragmentResult lhs = this.run(union.lhs(), argument);
            FragmentResult rhs = this.run(union.rhs(), argument);
            FragmentResult mergedResult = StatementResults.mergeUnion(lhs, rhs);
            if (union.distinct()) {
                return StatementResults.distinct(mergedResult);
            }
            return mergedResult;
        }

        private FragmentResult runExec(Fragment.Exec fragment, Record argument) {
            return new StandardQueryExecutor(fragment, this.plannerInstance, this.ctx, this.useEvaluator, this.plan, this.queryParams, this.accessMode, this.lifecycle, FabricExecutor.this.queryRoutingMonitor, this.tracer(), this::run).run(argument);
        }

        private FragmentResult runCallInTransactions(Fragment.Apply fragment, Record argument) {
            return new CallInTransactionsExecutor(fragment, this.plannerInstance, this.ctx, this.useEvaluator, this.plan, this.queryParams, this.accessMode, this.lifecycle, FabricExecutor.this.queryRoutingMonitor, this.tracer(), EffectiveQueryType.queryExecutionType(this.plan, this.accessMode), this::run).run(argument);
        }

        SingleQueryFragmentExecutor.Tracer tracer() {
            return new SingleQueryFragmentExecutor.Tracer(this){

                @Override
                public SingleQueryFragmentExecutor.RecordTracer remoteQueryStart(Location.Remote location, String queryString) {
                    return fragmentResult -> fragmentResult;
                }

                @Override
                public SingleQueryFragmentExecutor.RecordTracer localQueryStart(Location.Local location, FullyParsedQuery query) {
                    return fragmentResult -> fragmentResult;
                }
            };
        }

        private RuntimeException notImplemented(String msg, Object object) {
            return this.notImplemented(msg, object.toString());
        }

        private RuntimeException notImplemented(String msg, String info) {
            return new InvalidSemanticsException(msg + ": " + info);
        }
    }
}

