/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.cypher.internal.javacompat.InternalQueryExecutionEngine;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.LocalExecutionSummary;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.stream.InputDataStreamImpl;
import org.neo4j.fabric.stream.QueryInput;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.SourceTagging;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class FabricKernelTransaction {
    private final InternalQueryExecutionEngine queryExecutionEngine;
    private final TransactionalContextFactory transactionalContextFactory;
    private final InternalTransaction internalTransaction;
    private final FabricConfig config;
    private final Set<TransactionalContext> openExecutionContexts = ConcurrentHashMap.newKeySet();
    private final FabricTransactionInfo transactionInfo;

    FabricKernelTransaction(InternalQueryExecutionEngine queryExecutionEngine, TransactionalContextFactory transactionalContextFactory, InternalTransaction internalTransaction, FabricConfig config, FabricTransactionInfo transactionInfo) {
        this.queryExecutionEngine = queryExecutionEngine;
        this.transactionalContextFactory = transactionalContextFactory;
        this.internalTransaction = internalTransaction;
        this.config = config;
        this.transactionInfo = transactionInfo;
    }

    public StatementResult run(FullyParsedQuery query, MapValue params, QueryInput input, QueryStatementLifecycles.StatementLifecycle parentLifecycle, ExecutionOptions executionOptions) {
        TransactionalContext childExecutionContext = this.makeChildTransactionalContext(parentLifecycle);
        parentLifecycle.startExecution(true);
        QueryExecutionMonitor childQueryMonitor = parentLifecycle.getChildQueryMonitor();
        this.openExecutionContexts.add(childExecutionContext);
        long queryId = childExecutionContext.executingQuery().internalQueryId();
        try {
            int batchSize = this.config.getDataStream().getBatchSize();
            Tagging sourcetagging = new Tagging(executionOptions.sourceId());
            Function<AnyValue, AnyValue> valueTagging = executionOptions.addSourceTag() ? sourcetagging::toCompositeDatabaseValue : value -> value;
            QuerySubscriberImpl subscriber = new QuerySubscriberImpl(batchSize, valueTagging);
            QueryExecution execution = this.queryExecutionEngine.executeQuery(query, params, childExecutionContext, true, this.convert(input), childQueryMonitor, (QuerySubscriber)subscriber);
            return new StatementResultImpl(execution, subscriber, batchSize, childExecutionContext);
        }
        catch (QueryExecutionKernelException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw Exceptions.transformUnexpectedError((Status)Status.Statement.ExecutionFailed, cause, queryId);
        }
    }

    private TransactionalContext makeChildTransactionalContext(QueryStatementLifecycles.StatementLifecycle lifecycle) {
        ExecutingQuery parentQuery = lifecycle.getMonitoredQuery();
        QueryExecutionConfiguration queryExecutionConfiguration = this.transactionInfo.getQueryExecutionConfiguration();
        if (lifecycle.isParentChildMonitoringMode()) {
            String queryText = "Internal query for parent query id: " + parentQuery.id();
            MapValue params = MapValue.EMPTY;
            return this.transactionalContextFactory.newContext(this.internalTransaction, queryText, parentQuery, params, queryExecutionConfiguration);
        }
        return this.transactionalContextFactory.newContextForQuery(this.internalTransaction, parentQuery, queryExecutionConfiguration);
    }

    private InputDataStream convert(QueryInput input) {
        return new InputDataStreamImpl(input);
    }

    public void commit() {
        if (this.internalTransaction.isOpen()) {
            this.closeContexts();
            this.internalTransaction.commit();
        }
    }

    public void rollback() {
        if (this.internalTransaction.isOpen()) {
            this.closeContexts();
            this.internalTransaction.rollback();
        }
    }

    private void closeContexts() {
        this.openExecutionContexts.forEach(TransactionalContext::close);
    }

    public void terminate(Status reason) {
        this.terminateIfPossible(reason);
    }

    public void terminateIfPossible(Status reason) {
        if (this.internalTransaction.isOpen() && this.internalTransaction.terminationReason().isEmpty()) {
            this.internalTransaction.terminate(reason);
        }
    }

    @Deprecated
    public InternalTransaction getInternalTransaction() {
        return this.internalTransaction;
    }

    public long transactionSequenceNumber() {
        return this.internalTransaction.kernelTransaction().getTransactionSequenceNumber();
    }

    private static class Tagging {
        private final long sourceTagId;
        private final long sourceId;

        public Tagging(long sourceId) {
            this.sourceTagId = SourceTagging.makeSourceTag(sourceId);
            this.sourceId = sourceId;
        }

        private AnyValue toCompositeDatabaseValue(AnyValue value) {
            if (value instanceof VirtualNodeValue) {
                if (value instanceof NodeValue) {
                    NodeValue node = (NodeValue)value;
                    return this.toCompositeDatabaseValue(node);
                }
                throw Tagging.unableToTagError(value);
            }
            if (value instanceof VirtualRelationshipValue) {
                if (value instanceof RelationshipValue) {
                    RelationshipValue rel = (RelationshipValue)value;
                    return this.toCompositeDatabaseValue(rel);
                }
                throw Tagging.unableToTagError(value);
            }
            if (value instanceof PathValue) {
                return this.toCompositeDatabaseValue((PathValue)value);
            }
            if (value instanceof ListValue) {
                return this.toCompositeDatabaseValue((ListValue)value);
            }
            if (value instanceof MapValue) {
                return this.toCompositeDatabaseValue((MapValue)value);
            }
            return value;
        }

        private NodeValue toCompositeDatabaseValue(NodeValue n) {
            return VirtualValues.compositeGraphNodeValue((long)this.tag(n.id()), (String)n.elementId(), (long)this.sourceId, (TextArray)n.labels(), (MapValue)n.properties());
        }

        private RelationshipValue toCompositeDatabaseValue(RelationshipValue r) {
            return VirtualValues.compositeGraphRelationshipValue((long)r.id(), (String)r.elementId(), (long)this.sourceId, (VirtualNodeReference)VirtualValues.node((long)this.tag(r.startNodeId()), (String)r.startNode().elementId(), (long)this.sourceId), (VirtualNodeReference)VirtualValues.node((long)this.tag(r.endNodeId()), (String)r.endNode().elementId(), (long)this.sourceId), (TextValue)r.type(), (MapValue)r.properties());
        }

        private PathValue toCompositeDatabaseValue(PathValue pathValue) {
            return VirtualValues.path((NodeValue[])((NodeValue[])Arrays.stream(pathValue.nodes()).map(this::toCompositeDatabaseValue).toArray(NodeValue[]::new)), (RelationshipValue[])((RelationshipValue[])Arrays.stream(pathValue.relationships()).map(this::toCompositeDatabaseValue).toArray(RelationshipValue[]::new)));
        }

        private ListValue toCompositeDatabaseValue(ListValue listValue) {
            return VirtualValues.list((AnyValue[])((AnyValue[])Arrays.stream(listValue.asArray()).map(this::toCompositeDatabaseValue).toArray(AnyValue[]::new)));
        }

        private MapValue toCompositeDatabaseValue(MapValue mapValue) {
            if (mapValue.isEmpty()) {
                return mapValue;
            }
            MapValueBuilder builder = new MapValueBuilder(mapValue.size());
            mapValue.foreach((key, value) -> builder.add(key, this.toCompositeDatabaseValue((AnyValue)value)));
            return builder.build();
        }

        private long tag(long id) {
            return SourceTagging.tagId(id, this.sourceTagId);
        }

        private static FabricException unableToTagError(AnyValue value) {
            return new FabricException((Status)Status.General.UnknownError, "Unable to add graph id to entity of type " + value.getTypeName(), new Object[0]);
        }
    }

    private static class QuerySubscriberImpl
    implements QuerySubscriber {
        private final Function<AnyValue, AnyValue> valueTagging;
        private QueryStatistics statistics = null;
        private final Queue<Record> batch;
        private int numberOfFields = -1;
        private List<AnyValue> recordValues = null;
        private Throwable error;

        private QuerySubscriberImpl(int batchSize, Function<AnyValue, AnyValue> valueTagging) {
            this.batch = new ArrayDeque<Record>(batchSize);
            this.valueTagging = valueTagging;
        }

        public void onResult(int numberOfFields) {
            this.numberOfFields = numberOfFields;
        }

        public void onRecord() {
            this.recordValues = new ArrayList<AnyValue>(this.numberOfFields);
        }

        public void onField(int offset, AnyValue value) {
            this.recordValues.add(offset, this.valueTagging.apply(value));
        }

        public void onRecordCompleted() {
            this.batch.add(Records.of(this.recordValues));
        }

        public void onError(Throwable throwable) {
            this.error = throwable;
        }

        public void onResultCompleted(QueryStatistics statistics) {
            this.statistics = statistics;
        }
    }

    private class StatementResultImpl
    implements StatementResult {
        private final QueryExecution queryExecution;
        private final QuerySubscriberImpl querySubscriber;
        private final int batchSize;
        private final TransactionalContext executionContext;

        private StatementResultImpl(QueryExecution queryExecution, QuerySubscriberImpl querySubscriber, int batchSize, TransactionalContext executionContext) {
            this.queryExecution = queryExecution;
            this.querySubscriber = querySubscriber;
            this.batchSize = batchSize;
            this.executionContext = executionContext;
        }

        @Override
        public List<String> columns() {
            return Arrays.asList(this.queryExecution.fieldNames());
        }

        @Override
        public Record next() {
            Record record = this.querySubscriber.batch.poll();
            if (record != null) {
                return record;
            }
            if (this.querySubscriber.error != null) {
                throw Exceptions.transformUnexpectedError((Status)Status.Statement.ExecutionFailed, this.querySubscriber.error);
            }
            if (this.querySubscriber.statistics != null) {
                if (this.executionContext.isOpen()) {
                    FabricKernelTransaction.this.openExecutionContexts.remove(this.executionContext);
                    this.executionContext.close();
                }
                return null;
            }
            try {
                this.queryExecution.request((long)this.batchSize);
                this.queryExecution.await();
            }
            catch (Exception e) {
                throw Exceptions.transformUnexpectedError((Status)Status.Statement.ExecutionFailed, e);
            }
            return this.next();
        }

        @Override
        public Summary consume() {
            if (this.querySubscriber.statistics == null) {
                this.queryExecution.cancel();
            }
            return new LocalExecutionSummary(this.queryExecution, this.querySubscriber.statistics);
        }

        @Override
        public QueryExecutionType executionType() {
            return this.queryExecution.executionType();
        }
    }
}

