/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.fabric.executor.Location;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class FabricException
extends GqlRuntimeException
implements Status.HasStatus,
HasQuery {
    private final Status statusCode;
    private Long queryId;
    private static final String ROUTING_ENABLED_SETTING = GraphDatabaseSettings.routing_enabled.name();

    public FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, Throwable cause) {
        super(gqlStatusObject, ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public FabricException(Status statusCode, String message, Object ... parameters) {
        super(String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    public FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Object ... parameters) {
        super(gqlStatusObject, String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    private FabricException(Status statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    private FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public FabricException(Status statusCode, String message, Throwable cause, Long queryId) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = queryId;
    }

    public FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Throwable cause, Long queryId) {
        super(gqlStatusObject, message, cause);
        this.statusCode = statusCode;
        this.queryId = queryId;
    }

    private <T extends Throwable> FabricException(ErrorGqlStatusObject gqlStatusObject, T cause) {
        super(gqlStatusObject, cause.getMessage(), cause);
        this.statusCode = ((Status.HasStatus)cause).status();
    }

    public static <T extends Exception> FabricException translateLocalError(T localException) {
        ErrorGqlStatusObject gqlException;
        if (localException instanceof ErrorGqlStatusObject && (gqlException = (ErrorGqlStatusObject)localException).gqlStatusObject() != null) {
            return new FabricException(gqlException, localException);
        }
        return new FabricException(((Status.HasStatus)localException).status(), localException.getMessage(), localException);
    }

    public static FabricException internalError(String msgTitle, Status statusCode, String message, Object ... parameters) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new FabricException(gql, statusCode, message, parameters);
    }

    public static FabricException noLeaderAddress(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N00).withParam(GqlParams.StringParam.db, dbName).build();
        return new FabricException(gql, (Status)Status.Cluster.NotALeader, "Unable to route to database '%s'. Unable to get bolt address of leader.", dbName);
    }

    public static FabricException sessionDbNotLeader(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N01).withParam(GqlParams.StringParam.db, dbName).withParam(GqlParams.StringParam.cfgSetting, ROUTING_ENABLED_SETTING).build();
        return new FabricException(gql, (Status)Status.Cluster.NotALeader, String.format("No longer possible to write to database '%s' on this instance and unable to route write operation to leader. Server-side routing is disabled.\nEither connect to the database directly using the driver (or interactively with the :use command),\nor enable server-side routing by setting `%s=true`", dbName, ROUTING_ENABLED_SETTING), dbName);
    }

    public static FabricException routingDisabled(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N02).withParam(GqlParams.StringParam.db, dbName).withParam(GqlParams.StringParam.cfgSetting, ROUTING_ENABLED_SETTING).build();
        return new FabricException(gql, (Status)Status.Cluster.Routing, String.format("Unable to route to database '%s'. Server-side routing is disabled.\nEither connect to the database directly using the driver (or interactively with the :use command),\nor enable server-side routing by setting `%s=true`", dbName, ROUTING_ENABLED_SETTING), dbName);
    }

    public static FabricException failedToParseBookmark(Exception exception) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N12).build();
        return new FabricException(gql, (Status)Status.Transaction.InvalidBookmark, "Parsing of supplied bookmarks failed with message: " + exception.getMessage(), exception);
    }

    public static FabricException writeDuringLeaderSwitch(Location attempt, Location current) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N34).build();
        return new FabricException(gql, (Status)Status.Transaction.LeaderSwitch, "Could not write to a database due to a cluster leader switch that occurred during the transaction. Previous leader: %s, Current leader: %s.", current, attempt);
    }

    public static FabricException databaseLocationChanged(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N35).withParam(GqlParams.StringParam.db, dbName).build();
        return new FabricException(gql, (Status)Status.Transaction.Outdated, "The locations associated with the graph name %s have changed whilst the transaction was running.", dbName);
    }

    public static FabricException executeQueryInClosedTransaction() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N07).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N05).build()).build();
        return new FabricException(gql, (Status)Status.Statement.ExecutionFailed, "Trying to execute query in a closed transaction", new Object[0]);
    }

    public static FabricException invalidCombinationOfStatementTypes(String query, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N01).withParam(GqlParams.StringParam.query, query).build();
        return new FabricException(gql, (Status)Status.Transaction.ForbiddenDueToTransactionType, message, new Object[0]);
    }

    public static FabricException transactionCommitFailed(Status statusCode, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN01).build();
        return new FabricException(gql, statusCode, message, new Object[0]);
    }

    public static FabricException transactionRollbackFailed(Status statusCode, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N01).build();
        return new FabricException(gql, statusCode, message, new Object[0]);
    }

    public static FabricException transactionTerminationFailed(Status statusCode, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN03).build();
        return new FabricException(gql, statusCode, message, new Object[0]);
    }

    public static FabricException databaseUnavailable(String databaseName) {
        return new FabricException(GqlHelper.getGql08N09((String)databaseName), (Status)Status.General.DatabaseUnavailable, String.format("Unable to route to database '%s'. %s", databaseName, Status.General.DatabaseUnavailable.code().description()), new Object[0]);
    }

    public static FabricException importingValuesInRemoteSubqueries(String entityType, String variable, String graphName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N16).withParam(GqlParams.StringParam.expr, variable).withParam(GqlParams.StringParam.graph, graphName).build();
        return new FabricException(gql, (Status)Status.Statement.TypeError, String.format("Importing %s values in remote subqueries is currently not supported", entityType), new Object[0]);
    }

    public static FabricException writingInReadAccessMode(String graph) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N03).withParam(GqlParams.StringParam.graph, graph).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N02).build()).build();
        return new FabricException(gql, (Status)Status.Statement.AccessMode, "Writing in read access mode not allowed. Attempted write to %s", graph);
    }

    public static FabricException writingToMultipleGraphs(String attemptedGraph, String currentGraph) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N03).withParam(GqlParams.StringParam.graph, attemptedGraph).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N03).build()).build();
        return new FabricException(gql, (Status)Status.Statement.AccessMode, "Writing to more than one database per transaction is not allowed. Attempted write to %s, currently writing to %s", attemptedGraph, currentGraph);
    }

    public Status status() {
        return this.statusCode;
    }

    public Long query() {
        return this.queryId;
    }

    public void setQuery(Long queryId) {
        this.queryId = queryId;
    }
}

