/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream.summary;

import org.neo4j.graphdb.QueryStatistics;

public class MergedQueryStatistics
implements QueryStatistics {
    private int nodesCreated = 0;
    private int nodesDeleted = 0;
    private int relationshipsCreated = 0;
    private int relationshipsDeleted = 0;
    private int propertiesSet = 0;
    private int labelsAdded = 0;
    private int labelsRemoved = 0;
    private int indexesAdded = 0;
    private int indexesRemoved = 0;
    private int constraintsAdded = 0;
    private int constraintsRemoved = 0;
    private int systemUpdates = 0;
    private boolean containsUpdates;
    private boolean containsSystemUpdates;

    public void add(QueryStatistics delta) {
        this.nodesCreated += delta.getNodesCreated();
        this.nodesDeleted += delta.getNodesDeleted();
        this.relationshipsCreated += delta.getRelationshipsCreated();
        this.relationshipsDeleted += delta.getRelationshipsDeleted();
        this.propertiesSet += delta.getPropertiesSet();
        this.labelsAdded += delta.getLabelsAdded();
        this.labelsRemoved += delta.getLabelsRemoved();
        this.indexesAdded += delta.getIndexesAdded();
        this.indexesRemoved += delta.getIndexesRemoved();
        this.constraintsAdded += delta.getConstraintsAdded();
        this.constraintsRemoved += delta.getConstraintsRemoved();
        this.systemUpdates += delta.getSystemUpdates();
        if (delta.containsUpdates()) {
            this.containsUpdates = true;
        }
        if (delta.containsSystemUpdates()) {
            this.containsSystemUpdates = true;
        }
    }

    public int getNodesCreated() {
        return this.nodesCreated;
    }

    public int getNodesDeleted() {
        return this.nodesDeleted;
    }

    public int getRelationshipsCreated() {
        return this.relationshipsCreated;
    }

    public int getRelationshipsDeleted() {
        return this.relationshipsDeleted;
    }

    public int getPropertiesSet() {
        return this.propertiesSet;
    }

    public int getLabelsAdded() {
        return this.labelsAdded;
    }

    public int getLabelsRemoved() {
        return this.labelsRemoved;
    }

    public int getIndexesAdded() {
        return this.indexesAdded;
    }

    public int getIndexesRemoved() {
        return this.indexesRemoved;
    }

    public int getConstraintsAdded() {
        return this.constraintsAdded;
    }

    public int getConstraintsRemoved() {
        return this.constraintsRemoved;
    }

    public int getSystemUpdates() {
        return this.systemUpdates;
    }

    public boolean containsUpdates() {
        return this.containsUpdates;
    }

    public boolean containsSystemUpdates() {
        return this.containsSystemUpdates;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.containsSystemUpdates) {
            MergedQueryStatistics.includeIfNonZero(builder, "System updates: ", this.systemUpdates);
        } else {
            MergedQueryStatistics.includeIfNonZero(builder, "Nodes created: ", this.nodesCreated);
            MergedQueryStatistics.includeIfNonZero(builder, "Relationships created: ", this.relationshipsCreated);
            MergedQueryStatistics.includeIfNonZero(builder, "Properties set: ", this.propertiesSet);
            MergedQueryStatistics.includeIfNonZero(builder, "Nodes deleted: ", this.nodesDeleted);
            MergedQueryStatistics.includeIfNonZero(builder, "Relationships deleted: ", this.relationshipsDeleted);
            MergedQueryStatistics.includeIfNonZero(builder, "Labels added: ", this.labelsAdded);
            MergedQueryStatistics.includeIfNonZero(builder, "Labels removed: ", this.labelsRemoved);
            MergedQueryStatistics.includeIfNonZero(builder, "Indexes added: ", this.indexesAdded);
            MergedQueryStatistics.includeIfNonZero(builder, "Indexes removed: ", this.indexesRemoved);
            MergedQueryStatistics.includeIfNonZero(builder, "Constraints added: ", this.constraintsAdded);
            MergedQueryStatistics.includeIfNonZero(builder, "Constraints removed: ", this.constraintsRemoved);
        }
        String result = builder.toString();
        if (result.isEmpty()) {
            return "<Nothing happened>";
        }
        return result;
    }

    private static void includeIfNonZero(StringBuilder builder, String message, long count) {
        if (count > 0L) {
            builder.append(message).append(count).append("\n");
        }
    }
}

