/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction.parent;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.fabric.transaction.parent.ChildTransaction;
import org.neo4j.fabric.transaction.parent.CompoundTransaction;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransactionTerminatedHelper;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.time.SystemNanoClock;

public abstract class AbstractCompoundTransaction<Child extends ChildTransaction>
implements CompoundTransaction<Child> {
    private final CallableExecutor executor;
    private final ErrorReporter errorReporter;
    private final SystemNanoClock clock;
    private final ReadWriteLock transactionLock = new ReentrantReadWriteLock();
    protected final Lock nonExclusiveLock = this.transactionLock.readLock();
    protected final Lock exclusiveLock = this.transactionLock.writeLock();
    protected State state = State.OPEN;
    protected TerminationMark terminationMark;
    private final Set<CompoundTransaction.AutocommitQuery> autocommitQueries = ConcurrentHashMap.newKeySet();
    protected final Set<ReadingChildTransaction<Child>> readingTransactions = ConcurrentHashMap.newKeySet();
    protected Child writingTransaction;

    protected AbstractCompoundTransaction(ErrorReporter errorReporter, SystemNanoClock clock, CallableExecutor executor) {
        this.errorReporter = errorReporter;
        this.clock = clock;
        this.executor = executor;
    }

    @Override
    public <Tx extends Child> Tx registerNewChildTransaction(Location location, TransactionMode mode, Supplier<Tx> transactionSupplier) throws FabricException {
        return (Tx)(switch (mode) {
            default -> throw new MatchException(null, null);
            case TransactionMode.DEFINITELY_WRITE -> (ChildTransaction)this.startWritingTransaction(location, transactionSupplier);
            case TransactionMode.MAYBE_WRITE -> (ChildTransaction)this.startReadingTransaction(false, transactionSupplier);
            case TransactionMode.DEFINITELY_READ -> (ChildTransaction)this.startReadingTransaction(true, transactionSupplier);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Tx extends Child> Tx startWritingTransaction(Location location, Supplier<Tx> writeTransactionSupplier) throws FabricException {
        this.exclusiveLock.lock();
        try {
            this.checkTransactionOpenForStatementExecution();
            if (this.writingTransaction != null) {
                throw this.multipleWriteError(location, this.writingTransaction.location());
            }
            ChildTransaction tx = (ChildTransaction)writeTransactionSupplier.get();
            this.writingTransaction = tx;
            ChildTransaction childTransaction = tx;
            return (Tx)childTransaction;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TX extends Child> TX startReadingTransaction(boolean readOnly, Supplier<TX> readingTransactionSupplier) throws FabricException {
        this.nonExclusiveLock.lock();
        try {
            this.checkTransactionOpenForStatementExecution();
            ChildTransaction tx = (ChildTransaction)readingTransactionSupplier.get();
            this.readingTransactions.add(new ReadingChildTransaction<ChildTransaction>(tx, readOnly));
            ChildTransaction childTransaction = tx;
            return (TX)childTransaction;
        }
        finally {
            this.nonExclusiveLock.unlock();
        }
    }

    @Override
    public <Tx extends Child> void upgradeToWritingTransaction(Tx childTransaction) throws FabricException {
        if (this.writingTransaction == childTransaction) {
            return;
        }
        this.exclusiveLock.lock();
        try {
            if (this.writingTransaction == childTransaction) {
                return;
            }
            if (this.writingTransaction != null) {
                throw this.multipleWriteError(childTransaction.location(), this.writingTransaction.location());
            }
            ReadingChildTransaction readingTransaction = this.readingTransactions.stream().filter(readingTx -> readingTx.inner == childTransaction).findAny().orElseThrow(() -> new IllegalArgumentException("The supplied transaction has not been registered"));
            if (readingTransaction.readingOnly) {
                throw new IllegalStateException("Upgrading reading-only transaction to a writing one is not allowed");
            }
            this.readingTransactions.remove(readingTransaction);
            this.writingTransaction = (ChildTransaction)readingTransaction.inner;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.exclusiveLock.lock();
        try {
            if (this.state == State.TERMINATED) {
                this.doRollbackAndIgnoreErrors(this::childTransactionRollback);
                throw TransactionTerminatedHelper.transactionTerminated((Status)this.terminationMark.getReason());
            }
            if (this.state == State.CLOSED) {
                throw FabricException.transactionCommitFailed((Status)Status.Transaction.TransactionCommitFailed, "Trying to commit closed transaction");
            }
            this.state = State.CLOSED;
            ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
            try {
                this.doOnChildren(this.readingTransactions, null, this::childTransactionCommit).forEach(error -> allFailures.add(ErrorRecord.constituentCommitFailed("Failed to commit a child read transaction", error)));
                if (!allFailures.isEmpty()) {
                    this.doOnChildren(List.of(), this.writingTransaction, this::childTransactionRollback).forEach(error -> allFailures.add(ErrorRecord.constituentRollbackFailed("Failed to rollback a child write transaction", error)));
                } else {
                    this.doOnChildren(List.of(), this.writingTransaction, this::childTransactionCommit).forEach(error -> allFailures.add(ErrorRecord.constituentCommitFailed("Failed to commit a child write transaction", error)));
                }
            }
            catch (Exception e) {
                allFailures.add(ErrorRecord.commitFailed("Failed to commit composite transaction", (Throwable)((Object)this.commitFailedError())));
            }
            finally {
                this.closeContextsAndRemoveTransaction();
            }
            this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionCommitFailed);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public void rollback() {
        this.exclusiveLock.lock();
        try {
            if (this.isUninitialized()) {
                return;
            }
            if (this.state == State.TERMINATED) {
                this.doRollbackAndIgnoreErrors(this::childTransactionRollback);
                return;
            }
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
            this.doRollback(this::childTransactionRollback);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback(Consumer<Child> operation) {
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, operation).forEach(error -> allFailures.add(ErrorRecord.constituentRollbackFailed("Failed to rollback a child transaction", error)));
        }
        catch (Exception e) {
            allFailures.add(ErrorRecord.rollbackFailed("Failed to rollback composite transaction", (Throwable)((Object)this.rollbackFailedError())));
        }
        finally {
            this.closeContextsAndRemoveTransaction();
        }
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionRollbackFailed);
    }

    private void doRollbackAndIgnoreErrors(Consumer<Child> operation) {
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, operation);
        }
        finally {
            this.closeContextsAndRemoveTransaction();
        }
    }

    @Override
    public boolean markForTermination(Status reason) {
        try {
            do {
                if (this.state == State.OPEN) continue;
                return false;
            } while (!this.exclusiveLock.tryLock(100L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            throw this.terminationFailedError();
        }
        try {
            if (this.state != State.OPEN) {
                boolean bl = false;
                return bl;
            }
            this.terminationMark = new TerminationMark(reason, this.clock.nanos());
            this.state = State.TERMINATED;
            this.terminateChildren(reason);
            this.autocommitQueries.forEach(q -> q.terminate(reason));
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return true;
    }

    @Override
    public void childTransactionTerminated(Status reason) {
        if (!this.isOpen()) {
            return;
        }
        this.markForTermination(reason);
    }

    @Override
    public void registerAutocommitQuery(CompoundTransaction.AutocommitQuery autocommitQuery) {
        this.autocommitQueries.add(autocommitQuery);
        if (this.state == State.TERMINATED) {
            autocommitQuery.terminate(this.terminationMark.getReason());
        }
    }

    @Override
    public void unRegisterAutocommitQuery(CompoundTransaction.AutocommitQuery autocommitQuery) {
        this.autocommitQueries.remove(autocommitQuery);
    }

    private void terminateChildren(Status reason) {
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, singleDbTransaction -> this.childTransactionTerminate(singleDbTransaction, reason)).forEach(error -> allFailures.add(ErrorRecord.constituentTransactionTerminationFailed("Failed to terminate a child transaction", error)));
        }
        catch (Exception e) {
            allFailures.add(ErrorRecord.transactionTerminateFailed("Failed to terminate composite transaction", (Throwable)((Object)this.terminationFailedError())));
        }
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionTerminationFailed);
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public Optional<TerminationMark> getTerminationMark() {
        return Optional.ofNullable(this.terminationMark);
    }

    protected void checkTransactionOpenForStatementExecution() throws FabricException {
        if (this.state == State.TERMINATED) {
            throw TransactionTerminatedHelper.transactionTerminated((Status)this.terminationMark.getReason());
        }
        if (this.state == State.CLOSED) {
            throw FabricException.executeQueryInClosedTransaction();
        }
    }

    private List<Throwable> doOnChildren(Iterable<ReadingChildTransaction<Child>> readingTransactions, Child writingTransaction, Consumer<Child> operation) {
        ArrayList<Future> futures = new ArrayList<Future>();
        if (writingTransaction != null) {
            futures.add(this.executor.submit(() -> {
                operation.accept(writingTransaction);
                return null;
            }));
        }
        for (ReadingChildTransaction<Child> readingChildTransaction : readingTransactions) {
            futures.add(this.executor.submit(() -> {
                operation.accept((ChildTransaction)readingChildTransaction.inner);
                return null;
            }));
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                exceptions.add(e.getCause());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    private void throwIfNonEmpty(List<ErrorRecord> failures, Status defaultStatusCode) {
        if (!failures.isEmpty()) {
            RuntimeException mainException = Exceptions.transform(failures.get((int)0).gqlStatusObject, defaultStatusCode, failures.get((int)0).error);
            for (int i = 1; i < failures.size(); ++i) {
                ErrorRecord errorRecord = failures.get(i);
                mainException.addSuppressed(errorRecord.error);
                this.errorReporter.report(errorRecord.message, errorRecord.error, defaultStatusCode);
            }
            throw mainException;
        }
    }

    private FabricException multipleWriteError(Location attempt, Location current) {
        if (current.getUuid().equals(attempt.getUuid())) {
            return FabricException.writeDuringLeaderSwitch(attempt, current);
        }
        return FabricException.writingToMultipleGraphs(attempt.databaseReference().toPrettyString(), current.databaseReference().toPrettyString());
    }

    private FabricException commitFailedError() {
        return FabricException.transactionCommitFailed((Status)Status.Transaction.TransactionCommitFailed, "Failed to commit composite transaction");
    }

    private FabricException rollbackFailedError() {
        return FabricException.transactionRollbackFailed((Status)Status.Transaction.TransactionRollbackFailed, "Failed to rollback composite transaction");
    }

    private FabricException terminationFailedError() {
        return FabricException.transactionTerminationFailed((Status)Status.Transaction.TransactionTerminationFailed, "Failed to terminate composite transaction");
    }

    protected abstract boolean isUninitialized();

    protected abstract void closeContextsAndRemoveTransaction();

    protected abstract void childTransactionCommit(Child var1);

    protected abstract void childTransactionRollback(Child var1);

    protected abstract void childTransactionTerminate(Child var1, Status var2);

    protected static enum State {
        OPEN,
        CLOSED,
        TERMINATED;

    }

    private record ReadingChildTransaction<Tx>(Tx inner, boolean readingOnly) {
    }

    protected static class ErrorRecord {
        private final String message;
        private final Throwable error;
        private final ErrorGqlStatusObject gqlStatusObject;

        private ErrorRecord(ErrorGqlStatusObject gql, String message, Throwable error) {
            this.message = message;
            this.error = error;
            this.gqlStatusObject = gql;
        }

        public String message() {
            return this.message;
        }

        public Throwable error() {
            return this.error;
        }

        public ErrorGqlStatusObject gqlStatusObject() {
            return this.gqlStatusObject;
        }

        public static ErrorRecord commitFailed(String message, Throwable error) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN01).build();
            return new ErrorRecord(gql, message, error);
        }

        public static ErrorRecord constituentCommitFailed(String message, Throwable error) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN02).build();
            return new ErrorRecord(gql, message, error);
        }

        public static ErrorRecord rollbackFailed(String message, Throwable error) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N01).build();
            return new ErrorRecord(gql, message, error);
        }

        public static ErrorRecord constituentRollbackFailed(String message, Throwable error) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N02).build();
            return new ErrorRecord(gql, message, error);
        }

        public static ErrorRecord transactionTerminateFailed(String message, Throwable error) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN03).build();
            return new ErrorRecord(gql, message, error);
        }

        public static ErrorRecord constituentTransactionTerminationFailed(String message, Throwable error) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN04).build();
            return new ErrorRecord(gql, message, error);
        }
    }
}

