/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.configuration.helpers.SocketAddress;

public class Location {
    private final long graphId;
    private final UUID uuid;
    private final String databaseName;

    private Location(long graphId, UUID uuid, String databaseName) {
        this.graphId = graphId;
        this.uuid = uuid;
        this.databaseName = databaseName;
    }

    public long getGraphId() {
        return this.graphId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static class RemoteUri {
        private final String scheme;
        private final List<SocketAddress> addresses;
        private final String query;

        public RemoteUri(String scheme, List<SocketAddress> addresses, String query) {
            this.scheme = scheme;
            this.addresses = addresses;
            this.query = query;
        }

        public String getScheme() {
            return this.scheme;
        }

        public List<SocketAddress> getAddresses() {
            return this.addresses;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteUri remoteUri = (RemoteUri)o;
            return Objects.equals(this.scheme, remoteUri.scheme) && Objects.equals(this.addresses, remoteUri.addresses) && Objects.equals(this.query, remoteUri.query);
        }

        public int hashCode() {
            return Objects.hash(this.scheme, this.addresses, this.query);
        }

        public String toString() {
            return "RemoteUri{scheme='" + this.scheme + "', addresses=" + this.addresses + ", query='" + this.query + "'}";
        }
    }

    public static abstract class Remote
    extends Location {
        private final RemoteUri uri;

        protected Remote(long id, UUID uuid, RemoteUri uri, String databaseName) {
            super(id, uuid, databaseName);
            this.uri = uri;
        }

        public RemoteUri getUri() {
            return this.uri;
        }

        public static class External
        extends Remote {
            public External(long id, UUID uuid, RemoteUri uri, String databaseName) {
                super(id, uuid, uri, databaseName);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Remote remote = (Remote)o;
                return this.getUri().equals(remote.getUri()) || Objects.equals(this.getGraphId(), remote.getGraphId()) && Objects.equals(this.getUuid(), remote.getUuid()) && Objects.equals(this.getDatabaseName(), remote.getDatabaseName());
            }

            public int hashCode() {
                return Objects.hash(this.getUri(), this.getGraphId(), this.getUuid(), this.getDatabaseName());
            }

            public String toString() {
                return "External{graphId=" + this.getGraphId() + ", uuid=" + this.getUuid() + ", databaseName='" + this.getDatabaseName() + "', uri=" + this.getUri() + "}";
            }
        }

        public static class Internal
        extends Remote {
            public Internal(long id, UUID uuid, RemoteUri uri, String databaseName) {
                super(id, uuid, uri, databaseName);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Remote remote = (Remote)o;
                return this.getUri().equals(remote.getUri()) || Objects.equals(this.getGraphId(), remote.getGraphId()) && Objects.equals(this.getUuid(), remote.getUuid()) && Objects.equals(this.getDatabaseName(), remote.getDatabaseName());
            }

            public int hashCode() {
                return Objects.hash(this.getUri(), this.getGraphId(), this.getUuid(), this.getDatabaseName());
            }

            public String toString() {
                return "Internal{graphId=" + this.getGraphId() + ", uuid=" + this.getUuid() + ", databaseName='" + this.getDatabaseName() + "', uri=" + this.getUri() + "}";
            }
        }
    }

    public static class Local
    extends Location {
        public Local(long id, UUID uuid, String databaseName) {
            super(id, uuid, databaseName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Local local = (Local)o;
            return Objects.equals(this.getGraphId(), local.getGraphId()) && Objects.equals(this.getUuid(), local.getUuid()) && Objects.equals(this.getDatabaseName(), local.getDatabaseName());
        }

        public int hashCode() {
            return Objects.hash(this.getGraphId(), this.getUuid(), this.getDatabaseName());
        }

        public String toString() {
            return "Local{graphId=" + this.getGraphId() + ", uuid=" + this.getUuid() + ", databaseName='" + this.getDatabaseName() + "'}";
        }
    }
}

