/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.CatalogName$;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.ast.SchemaCommand;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.Union;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.fabric.util.Errors$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005)4Aa\u0003\u0007\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)\u0011\u0007\u0001C\u0001e!)!\b\u0001C\u0001w!)\u0011\t\u0001C\u0005\u0005\")A\t\u0001C\u0005\u000b\")!\u000b\u0001C\u0005'\")a\u000b\u0001C\u0005/\")\u0011\f\u0001C\t5\")1\r\u0001C\tI\n\u00192\u000b^1uS\u000e,6/Z#wC2,\u0018\r^5p]*\u0011QBD\u0001\u0005KZ\fGN\u0003\u0002\u0010!\u00051a-\u00192sS\u000eT!!\u0005\n\u0002\u000b9,w\u000e\u000e6\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\tA\"\u0001\u0005jgN#\u0018\r^5d)\t\u0011S\u0005\u0005\u0002\u0018G%\u0011A\u0005\u0007\u0002\b\u0005>|G.Z1o\u0011\u00151#\u00011\u0001(\u000399'/\u00199i'\u0016dWm\u0019;j_:\u0004\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u0007\u0005\u001cHO\u0003\u0002-[\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002/!\u000511-\u001f9iKJL!\u0001M\u0015\u0003\u001d\u001d\u0013\u0018\r\u001d5TK2,7\r^5p]\u0006!RM^1mk\u0006$Xm\u0015;bi&\u001cw\n\u001d;j_:$\"aM\u001d\u0011\u0007]!d'\u0003\u000261\t1q\n\u001d;j_:\u0004\"\u0001K\u001c\n\u0005aJ#aC\"bi\u0006dwn\u001a(b[\u0016DQAJ\u0002A\u0002\u001d\n1%\u001a<bYV\fG/Z*uCRL7\rT3bI&twm\u0012:ba\"\u001cV\r\\3di&|g\u000e\u0006\u00024y!)Q\b\u0002a\u0001}\u0005I1\u000f^1uK6,g\u000e\u001e\t\u0003Q}J!\u0001Q\u0015\u0003\u0013M#\u0018\r^3nK:$\u0018AD3wC2,\u0018\r^3Ti\u0006$\u0018n\u0019\u000b\u0003m\rCQAJ\u0003A\u0002\u001d\n1\u0003\\3gi6|7\u000f^*j]\u001edW-U;fef$\"A\u0012&\u0011\u0007]!t\t\u0005\u0002)\u0011&\u0011\u0011*\u000b\u0002\f'&tw\r\\3Rk\u0016\u0014\u0018\u0010C\u0003>\r\u0001\u0007a\b\u000b\u0002\u0007\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nG\u0001\u000bC:tw\u000e^1uS>t\u0017BA)O\u0005\u001d!\u0018-\u001b7sK\u000e\fQ\u0003\\3bI&twm\u0012:ba\"\u001cV\r\\3di&|g\u000e\u0006\u0002U+B\u0019q\u0003N\u0014\t\u000bu:\u0001\u0019\u0001 \u00025E,XM]=MK\u0006$\u0017N\\4He\u0006\u0004\bnU3mK\u000e$\u0018n\u001c8\u0015\u0005QC\u0006\"B\u001f\t\u0001\u0004q\u0014a\u00038b[\u00164%o\\7WCJ$\"AN.\t\u000bqK\u0001\u0019A/\u0002\u0011Y\f'/[1cY\u0016\u0004\"AX1\u000e\u0003}S!\u0001Y\u0016\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003E~\u0013\u0001BV1sS\u0006\u0014G.Z\u0001\r]\u0006lWM\u0012:p[B\u0013x\u000e\u001d\u000b\u0003m\u0015DQA\u001a\u0006A\u0002\u001d\f\u0001\u0002\u001d:pa\u0016\u0014H/\u001f\t\u0003=\"L!![0\u0003\u0011A\u0013x\u000e]3sif\u0004")
public class StaticUseEvaluation {
    public boolean isStatic(GraphSelection graphSelection) {
        Expression expression = graphSelection.expression();
        return expression instanceof Variable ? true : expression instanceof Property;
    }

    public Option<CatalogName> evaluateStaticOption(GraphSelection graphSelection) {
        Expression expression = graphSelection.expression();
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            return new Some((Object)this.nameFromVar(variable));
        }
        if (expression instanceof Property) {
            Property property = (Property)expression;
            return new Some((Object)this.nameFromProp(property));
        }
        return None$.MODULE$;
    }

    public Option<CatalogName> evaluateStaticLeadingGraphSelection(Statement statement) {
        return this.leadingGraphSelection(statement).map((Function1 & Serializable)graphSelection -> this.evaluateStatic((GraphSelection)graphSelection));
    }

    private CatalogName evaluateStatic(GraphSelection graphSelection) {
        return (CatalogName)this.evaluateStaticOption(graphSelection).getOrElse((Function0 & Serializable)() -> Errors$.MODULE$.dynamicGraphNotAllowed(graphSelection));
    }

    private Option<SingleQuery> leftmostSingleQuery(Statement statement) {
        while (true) {
            Statement statement2;
            if ((statement2 = statement) instanceof SingleQuery) {
                SingleQuery singleQuery = (SingleQuery)statement2;
                return new Some((Object)singleQuery);
            }
            if (!(statement2 instanceof Union)) break;
            Union union = (Union)statement2;
            statement = union.lhs();
        }
        return None$.MODULE$;
    }

    private Option<GraphSelection> leadingGraphSelection(Statement statement) {
        Statement statement2 = statement;
        if (statement2 instanceof SchemaCommand) {
            SchemaCommand schemaCommand = (SchemaCommand)statement2;
            return schemaCommand.useGraph();
        }
        return this.queryLeadingGraphSelection(statement);
    }

    private Option<GraphSelection> queryLeadingGraphSelection(Statement statement) {
        Option<SingleQuery> singleQuery = this.leftmostSingleQuery(statement);
        Option clause = singleQuery.flatMap((Function1 & Serializable)x$1 -> x$1.clauses().headOption());
        return clause.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Clause, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof GraphSelection) {
                    GraphSelection graphSelection = (GraphSelection)A1;
                    return (B1)graphSelection;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Clause x1) {
                Clause clause = x1;
                return clause instanceof GraphSelection;
            }
        });
    }

    public CatalogName nameFromVar(Variable variable) {
        return CatalogName$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{variable.name()}));
    }

    public CatalogName nameFromProp(Property property) {
        return new CatalogName(StaticUseEvaluation.parts$1((Expression)property));
    }

    private static final List parts$1(Expression expr) {
        Expression expression = expr;
        if (expression instanceof Property) {
            Property property = (Property)expression;
            return (List)StaticUseEvaluation.parts$1(property.map()).$colon$plus((Object)property.propertyKey().name());
        }
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            String name = variable.name();
            return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        }
        throw Errors$.MODULE$.openCypherUnexpected("Graph name segment", (ASTNode)expression);
    }
}

