/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.compiler.helpers.SignatureResolver;
import org.neo4j.cypher.internal.evaluator.StaticEvaluation;
import org.neo4j.cypher.internal.expressions.AutoExtractedParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.planner.spi.ProcedureSignatureResolver;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.EffectiveQueryType;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricSecondaryException;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.QueryTypes;
import org.neo4j.fabric.executor.TaggingPlanDescriptionWrapper;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.FabricQuery;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.planning.QueryType;
import org.neo4j.fabric.stream.CompletionDelegatingOperator;
import org.neo4j.fabric.stream.Prefetcher;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.StatementResults;
import org.neo4j.fabric.stream.summary.MergedQueryStatistics;
import org.neo4j.fabric.stream.summary.MergedSummary;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

public class FabricExecutor {
    public static final String WRITING_IN_READ_NOT_ALLOWED_MSG = "Writing in read access mode not allowed";
    private final FabricConfig.DataStream dataStreamConfig;
    private final FabricPlanner planner;
    private final UseEvaluation useEvaluation;
    private final InternalLog log;
    private final QueryStatementLifecycles statementLifecycles;
    private final Executor fabricWorkerExecutor;
    private final QueryRoutingMonitor queryRoutingMonitor;

    public FabricExecutor(FabricConfig config, FabricPlanner planner, UseEvaluation useEvaluation, InternalLogProvider internalLog, QueryStatementLifecycles statementLifecycles, Executor fabricWorkerExecutor, Monitors monitors) {
        this.dataStreamConfig = config.getDataStream();
        this.planner = planner;
        this.useEvaluation = useEvaluation;
        this.log = internalLog.getLog(this.getClass());
        this.statementLifecycles = statementLifecycles;
        this.fabricWorkerExecutor = fabricWorkerExecutor;
        this.queryRoutingMonitor = (QueryRoutingMonitor)monitors.newMonitor(QueryRoutingMonitor.class, new String[0]);
    }

    public StatementResult run(FabricTransaction fabricTransaction, String statement, MapValue parameters) {
        ExecutingQuery.TransactionBinding transactionBinding = fabricTransaction.transactionBinding();
        QueryStatementLifecycles.StatementLifecycle lifecycle = this.statementLifecycles.create(fabricTransaction.getTransactionInfo(), statement, parameters, transactionBinding);
        lifecycle.startProcessing();
        Procedures procedures = fabricTransaction.contextlessProcedures();
        SignatureResolver signatureResolver = SignatureResolver.from((Procedures)procedures);
        StaticEvaluation.StaticEvaluator evaluator = StaticEvaluation.from((Procedures)procedures);
        try {
            String defaultGraphName = fabricTransaction.getTransactionInfo().getSessionDatabaseReference().alias().name();
            Catalog catalog = fabricTransaction.getCatalogSnapshot();
            FabricPlanner.PlannerInstance plannerInstance = this.planner.instance((ProcedureSignatureResolver)signatureResolver, statement, parameters, defaultGraphName, catalog, fabricTransaction.cancellationChecker());
            FabricPlan plan = plannerInstance.plan();
            Fragment query = plan.query();
            lifecycle.doneFabricProcessing(plan);
            AccessMode accessMode = fabricTransaction.getTransactionInfo().getAccessMode();
            if (plan.debugOptions().logPlan()) {
                this.log.debug(String.format("Fabric plan: %s", Fragment.pretty().asString(query)));
            }
            StatementResult statementResult = fabricTransaction.execute(ctx -> {
                UseEvaluation.Instance useEvaluator = this.useEvaluation.instance(evaluator, (ProcedureSignatureResolver)signatureResolver, statement, catalog);
                FabricStatementExecution execution = plan.debugOptions().logRecords() ? new FabricLoggingStatementExecution(plan, plannerInstance, useEvaluator, parameters, accessMode, (FabricTransaction.FabricExecutionContext)ctx, this.log, lifecycle, this.dataStreamConfig, fabricTransaction.getTransactionInfo().getQueryExecutionConfiguration().notificationFilters()) : new FabricStatementExecution(plan, plannerInstance, useEvaluator, parameters, accessMode, (FabricTransaction.FabricExecutionContext)ctx, lifecycle, this.dataStreamConfig, fabricTransaction.getTransactionInfo().getQueryExecutionConfiguration().notificationFilters());
                return execution.run();
            });
            return StatementResults.withErrorMapping(statementResult, FabricSecondaryException.class, FabricSecondaryException::getPrimaryException);
        }
        catch (RuntimeException e) {
            lifecycle.endFailure(e);
            throw e;
        }
    }

    public long clearQueryCachesForDatabase(String databaseName) {
        return this.planner.queryCache().clearByContext(databaseName);
    }

    private class FabricLoggingStatementExecution
    extends FabricStatementExecution {
        private final AtomicInteger step;
        private final InternalLog log;

        FabricLoggingStatementExecution(FabricPlan plan, FabricPlanner.PlannerInstance plannerInstance, UseEvaluation.Instance useEvaluator, MapValue params, AccessMode accessMode, FabricTransaction.FabricExecutionContext ctx, InternalLog log, QueryStatementLifecycles.StatementLifecycle lifecycle, FabricConfig.DataStream dataStreamConfig, NotificationConfiguration notificationConfiguration) {
            super(plan, plannerInstance, useEvaluator, params, accessMode, ctx, lifecycle, dataStreamConfig, notificationConfiguration);
            this.step = new AtomicInteger(0);
            this.log = log;
        }

        @Override
        FragmentResult runLocalQueryAt(Location.Local location, TransactionMode transactionMode, FullyParsedQuery query, MapValue parameters, boolean targetsComposite, Flux<Record> input) {
            String id = this.executionId();
            this.trace(id, "local " + FabricLoggingStatementExecution.nameString(location), this.compact(query.description()));
            return this.traceRecords(id, super.runLocalQueryAt(location, transactionMode, query, parameters, targetsComposite, input));
        }

        @Override
        FragmentResult runRemoteQueryAt(Location.Remote location, TransactionMode transactionMode, String queryString, MapValue parameters) {
            String id = this.executionId();
            this.trace(id, "remote " + FabricLoggingStatementExecution.nameString(location), this.compact(queryString));
            return this.traceRecords(id, super.runRemoteQueryAt(location, transactionMode, queryString, parameters));
        }

        private static String nameString(Location location) {
            Stream<String> namespace = location.databaseReference().namespace().map(NormalizedDatabaseName::name).stream();
            Stream<String> name = Stream.of(location.databaseReference().alias().name());
            return Stream.concat(namespace, name).collect(Collectors.joining("."));
        }

        private String compact(String in) {
            return in.replaceAll("\\r?\\n", " ").replaceAll("\\s+", " ");
        }

        private FragmentResult traceRecords(String id, FragmentResult fragmentResult) {
            Flux records = fragmentResult.records.doOnNext(record -> {
                String rec = IntStream.range(0, record.size()).mapToObj(i -> record.getValue(i).toString()).collect(Collectors.joining(", ", "[", "]"));
                this.trace(id, "output", rec);
            }).doOnError(err -> {
                String rec = err.getClass().getSimpleName() + ": " + err.getMessage();
                this.trace(id, "error", rec);
            }).doOnCancel(() -> this.trace(id, "cancel", "cancel")).doOnComplete(() -> this.trace(id, "complete", "complete"));
            return new FragmentResult((Flux<Record>)records, fragmentResult.planDescription, fragmentResult.executionType);
        }

        private void trace(String id, String event, String data) {
            this.log.debug(String.format("%s: %s: %s", id, event, data));
        }

        private String executionId() {
            String stmtId = this.idString(this.hashCode());
            String step = this.idString(this.step.getAndIncrement());
            return String.format("%s/%s", stmtId, step);
        }

        private String idString(int code) {
            return String.format("%08X", code);
        }
    }

    private class FabricStatementExecution {
        private final FabricPlan plan;
        private final FabricPlanner.PlannerInstance plannerInstance;
        private final UseEvaluation.Instance useEvaluator;
        private final MapValue queryParams;
        private final FabricTransaction.FabricExecutionContext ctx;
        private final MergedQueryStatistics statistics = new MergedQueryStatistics();
        private final Set<Notification> notifications = ConcurrentHashMap.newKeySet();
        private final QueryStatementLifecycles.StatementLifecycle lifecycle;
        private final Prefetcher prefetcher;
        private final AccessMode accessMode;
        private final NotificationConfiguration notificationConfiguration;

        FabricStatementExecution(FabricPlan plan, FabricPlanner.PlannerInstance plannerInstance, UseEvaluation.Instance useEvaluator, MapValue queryParams, AccessMode accessMode, FabricTransaction.FabricExecutionContext ctx, QueryStatementLifecycles.StatementLifecycle lifecycle, FabricConfig.DataStream dataStreamConfig, NotificationConfiguration notificationConfiguration) {
            this.plan = plan;
            this.plannerInstance = plannerInstance;
            this.useEvaluator = useEvaluator;
            this.queryParams = queryParams;
            this.ctx = ctx;
            this.lifecycle = lifecycle;
            this.prefetcher = new Prefetcher(dataStreamConfig);
            this.accessMode = accessMode;
            this.notificationConfiguration = notificationConfiguration;
        }

        StatementResult run() {
            Flux records;
            java.util.List columns;
            List filteredNotifications = ((Iterable)this.plan.notifications().filter(arg_0 -> ((NotificationConfiguration)this.notificationConfiguration).includes(arg_0))).toList();
            this.notifications.addAll(CollectionConverters.asJava((Seq)filteredNotifications));
            this.lifecycle.startExecution(false);
            Fragment query = this.plan.query();
            if (this.plan.executionType() == FabricPlan.EXPLAIN() && this.plan.inCompositeContext()) {
                this.lifecycle.endSuccess();
                return StatementResults.create(CollectionConverters.asJava(query.outputColumns()), (Flux<Record>)Flux.empty(), (Mono<Summary>)Mono.just((Object)new MergedSummary((Mono<ExecutionPlanDescription>)Mono.just((Object)this.plan.query().description()), this.statistics, this.notifications)), (Mono<QueryExecutionType>)Mono.just((Object)EffectiveQueryType.queryExecutionType(this.plan, this.accessMode)));
            }
            FragmentResult fragmentResult = this.run(query, null);
            if (query.producesResults()) {
                columns = CollectionConverters.asJava(query.outputColumns());
                records = fragmentResult.records;
            } else {
                columns = Collections.emptyList();
                records = fragmentResult.records.then(Mono.empty()).flux();
            }
            Mono summary = Mono.just((Object)new MergedSummary(fragmentResult.planDescription, this.statistics, this.notifications));
            return StatementResults.create(columns, (Flux<Record>)records.doOnComplete(this.lifecycle::endSuccess).doOnCancel(this.lifecycle::endSuccess).doOnError(this.lifecycle::endFailure), (Mono<Summary>)summary, fragmentResult.executionType);
        }

        FragmentResult run(Fragment fragment, Record argument) {
            if (fragment instanceof Fragment.Init) {
                return this.runInit();
            }
            if (fragment instanceof Fragment.Apply) {
                return this.runApply((Fragment.Apply)fragment, argument);
            }
            if (fragment instanceof Fragment.Union) {
                return this.runUnion((Fragment.Union)fragment, argument);
            }
            if (fragment instanceof Fragment.Exec) {
                return this.runExec((Fragment.Exec)fragment, argument);
            }
            throw this.notImplemented("Invalid query fragment", fragment);
        }

        FragmentResult runInit() {
            return new FragmentResult((Flux<Record>)Flux.just((Object)Records.empty()), (Mono<ExecutionPlanDescription>)Mono.empty(), (Mono<QueryExecutionType>)Mono.empty());
        }

        FragmentResult runApply(Fragment.Apply apply, Record argument) {
            FragmentResult input = this.run(apply.input(), argument);
            Function<Record, Publisher> runInner = apply.inner().outputColumns().isEmpty() ? record -> this.runAndProduceOnlyRecord(apply.inner(), (Record)record) : record -> this.runAndProduceJoinedResult(apply.inner(), (Record)record);
            Flux resultRecords = input.records.flatMap(runInner, FabricExecutor.this.dataStreamConfig.getConcurrency(), 1);
            Mono executionType = Mono.just((Object)EffectiveQueryType.queryExecutionType(this.plan, this.accessMode));
            return new FragmentResult((Flux<Record>)resultRecords, (Mono<ExecutionPlanDescription>)Mono.empty(), (Mono<QueryExecutionType>)executionType);
        }

        private Flux<Record> runAndProduceJoinedResult(Fragment fragment, Record record) {
            return this.run((Fragment)fragment, (Record)record).records.map(outputRecord -> Records.join(record, outputRecord));
        }

        private Mono<Record> runAndProduceOnlyRecord(Fragment fragment, Record record) {
            return this.run((Fragment)fragment, (Record)record).records.then(Mono.just((Object)record));
        }

        FragmentResult runUnion(Fragment.Union union, Record argument) {
            FragmentResult lhs = this.run(union.lhs(), argument);
            FragmentResult rhs = this.run(union.rhs(), argument);
            Flux merged = Flux.merge((Publisher[])new Publisher[]{lhs.records, rhs.records});
            Mono<QueryExecutionType> executionType = this.mergeExecutionType(lhs.executionType, rhs.executionType);
            if (union.distinct()) {
                return new FragmentResult((Flux<Record>)merged.distinct(), (Mono<ExecutionPlanDescription>)Mono.empty(), executionType);
            }
            return new FragmentResult((Flux<Record>)merged, (Mono<ExecutionPlanDescription>)Mono.empty(), executionType);
        }

        FragmentResult runExec(Fragment.Exec fragment, Record argument) {
            this.ctx.validateStatementType(fragment.statementType());
            Map<String, AnyValue> argumentValues = this.argumentValues(fragment, argument);
            Catalog.Graph graph = this.evalUse(fragment.use().graphSelection(), argumentValues, this.ctx.getSessionDatabaseReference());
            this.validateCanUseGraph(graph, this.ctx.getSessionDatabaseReference());
            TransactionMode transactionMode = this.getTransactionMode(fragment.queryType(), graph.reference().toPrettyString());
            MapValue parameters = this.addParamsFromRecord(this.queryParams, argumentValues, CollectionConverters.asJava(fragment.parameters()));
            Location location = this.ctx.locationOf(graph, transactionMode.requiresWrite());
            if (location instanceof Location.Local) {
                Location.Local local = (Location.Local)location;
                FragmentResult input = this.run(fragment.input(), argument);
                if (fragment.executable()) {
                    FabricQuery.LocalQuery localQuery = this.plannerInstance.asLocal(fragment);
                    boolean targetsComposite = this.plannerInstance.targetsComposite(fragment);
                    FragmentResult fragmentResult = this.runLocalQueryAt(local, transactionMode, localQuery.query(), parameters, targetsComposite, input.records);
                    Mono<QueryExecutionType> executionType = this.mergeExecutionType(input.executionType, fragmentResult.executionType);
                    return new FragmentResult(fragmentResult.records, fragmentResult.planDescription, executionType);
                }
                return input;
            }
            if (location instanceof Location.Remote) {
                Location.Remote remote = (Location.Remote)location;
                FabricQuery.RemoteQuery remoteQuery = this.plannerInstance.asRemote(fragment);
                Map extracted = CollectionConverters.asJava(remoteQuery.extractedLiterals());
                MapValueBuilder builder = new MapValueBuilder();
                StaticEvaluation.StaticEvaluator evaluator = this.useEvaluator.evaluator();
                for (Map.Entry entry : extracted.entrySet()) {
                    builder.add(((AutoExtractedParameter)entry.getKey()).name(), evaluator.evaluate((Expression)entry.getValue(), VirtualValues.EMPTY_MAP, CypherRow.empty()));
                }
                MapValue fullParams = parameters.updatedWith(builder.build());
                return this.runRemoteQueryAt(remote, transactionMode, remoteQuery.query(), fullParams);
            }
            throw this.notImplemented("Invalid graph location", location);
        }

        private void validateCanUseGraph(Catalog.Graph accessedGraph, DatabaseReference sessionDatabaseReference) {
            Catalog.Graph sessionGraph = this.useEvaluator.resolveGraph(sessionDatabaseReference.alias());
            if (sessionGraph instanceof Catalog.Composite) {
                if (!this.useEvaluator.isConstituentOrSelf(accessedGraph, sessionGraph) && !this.useEvaluator.isSystem(accessedGraph)) {
                    throw new InvalidSemanticsException(this.cantAccessOutsideCompositeMessage(sessionGraph, accessedGraph));
                }
            } else if (!this.useEvaluator.isDatabaseOrAliasInRoot(accessedGraph)) {
                throw new InvalidSemanticsException(this.cantAccessCompositeConstituentsMessage(sessionGraph, accessedGraph));
            }
        }

        private String cantAccessOutsideCompositeMessage(Catalog.Graph sessionDatabase, Catalog.Graph accessed) {
            return "When connected to a composite database, access is allowed only to its constituents. " + "Attempted to access '%s' while connected to '%s'".formatted(this.useEvaluator.qualifiedNameString(accessed), this.useEvaluator.qualifiedNameString(sessionDatabase));
        }

        private String cantAccessCompositeConstituentsMessage(Catalog.Graph sessionDatabase, Catalog.Graph accessed) {
            return "Accessing a composite database and its constituents is only allowed when connected to it. " + "Attempted to access '%s' while connected to '%s'".formatted(this.useEvaluator.qualifiedNameString(accessed), this.useEvaluator.qualifiedNameString(sessionDatabase));
        }

        FragmentResult runLocalQueryAt(Location.Local location, TransactionMode transactionMode, FullyParsedQuery query, MapValue parameters, boolean targetsComposite, Flux<Record> input) {
            ExecutionOptions executionOptions = this.plan.inCompositeContext() && !targetsComposite ? new ExecutionOptions(location.graphId()) : new ExecutionOptions();
            StatementResult localStatementResult = this.ctx.getLocal().run(location, transactionMode, this.lifecycle, query, parameters, input, executionOptions, targetsComposite);
            Flux records = localStatementResult.records().doOnComplete(() -> localStatementResult.summary().subscribe(this::updateSummary));
            Mono planDescription = localStatementResult.summary().map(Summary::executionPlanDescription).map(pd -> new TaggingPlanDescriptionWrapper((ExecutionPlanDescription)pd, location.getDatabaseName()));
            FabricExecutor.this.queryRoutingMonitor.queryRoutedLocal();
            return new FragmentResult((Flux<Record>)records, (Mono<ExecutionPlanDescription>)planDescription, localStatementResult.executionType());
        }

        FragmentResult runRemoteQueryAt(Location.Remote location, TransactionMode transactionMode, String queryString, MapValue parameters) {
            ExecutionOptions executionOptions = this.plan.inCompositeContext() ? new ExecutionOptions(location.graphId()) : new ExecutionOptions();
            this.lifecycle.startExecution(true);
            Mono<StatementResult> statementResult = this.ctx.getRemote().run(location, executionOptions, queryString, transactionMode, parameters);
            Flux records = statementResult.flatMapMany(sr -> sr.records().doOnComplete(() -> sr.summary().subscribe(this::updateSummary)));
            CompletionDelegatingOperator recordsWithCompletionDelegation = new CompletionDelegatingOperator((Flux<Record>)records, FabricExecutor.this.fabricWorkerExecutor);
            Flux<Record> prefetchedRecords = this.prefetcher.addPrefetch((Flux<Record>)recordsWithCompletionDelegation);
            Mono planDescription = statementResult.flatMap(StatementResult::summary).map(Summary::executionPlanDescription);
            Mono executionType = Mono.just((Object)EffectiveQueryType.queryExecutionType(this.plan, this.accessMode));
            if (location instanceof Location.Remote.Internal) {
                FabricExecutor.this.queryRoutingMonitor.queryRoutedRemoteInternal();
            } else if (location instanceof Location.Remote.External) {
                FabricExecutor.this.queryRoutingMonitor.queryRoutedRemoteExternal();
            }
            return new FragmentResult(prefetchedRecords, (Mono<ExecutionPlanDescription>)planDescription, (Mono<QueryExecutionType>)executionType);
        }

        private Map<String, AnyValue> argumentValues(Fragment fragment, Record argument) {
            if (argument == null) {
                return Map.of();
            }
            return Records.asMap(argument, CollectionConverters.asJava(fragment.argumentColumns()));
        }

        private Catalog.Graph evalUse(GraphSelection selection, Map<String, AnyValue> record, DatabaseReference sessionDb) {
            return this.useEvaluator.evaluate(selection, this.queryParams, record, sessionDb);
        }

        private MapValue addParamsFromRecord(MapValue params, Map<String, AnyValue> record, Map<String, String> bindings) {
            int resultSize = params.size() + bindings.size();
            if (resultSize == 0) {
                return VirtualValues.EMPTY_MAP;
            }
            MapValueBuilder builder = new MapValueBuilder(resultSize);
            params.foreach((arg_0, arg_1) -> ((MapValueBuilder)builder).add(arg_0, arg_1));
            bindings.forEach((var, par) -> builder.add(par, this.validateValue((AnyValue)record.get(var))));
            return builder.build();
        }

        private AnyValue validateValue(AnyValue value) {
            if (value instanceof VirtualNodeValue) {
                throw new FabricException((Status)Status.Statement.TypeError, "Importing node values in remote subqueries is currently not supported", new Object[0]);
            }
            if (value instanceof VirtualRelationshipValue) {
                throw new FabricException((Status)Status.Statement.TypeError, "Importing relationship values in remote subqueries is currently not supported", new Object[0]);
            }
            if (value instanceof PathValue) {
                throw new FabricException((Status)Status.Statement.TypeError, "Importing path values in remote subqueries is currently not supported", new Object[0]);
            }
            return value;
        }

        private void updateSummary(Summary summary) {
            if (summary != null) {
                this.statistics.add(summary.getQueryStatistics());
                this.notifications.addAll(summary.getNotifications());
            }
        }

        private Mono<QueryExecutionType> mergeExecutionType(Mono<QueryExecutionType> lhs, Mono<QueryExecutionType> rhs) {
            return Mono.zip(lhs, rhs).map(both -> QueryTypes.merge((QueryExecutionType)both.getT1(), (QueryExecutionType)both.getT2())).switchIfEmpty(lhs).switchIfEmpty(rhs);
        }

        private RuntimeException notImplemented(String msg, Object object) {
            return this.notImplemented(msg, object.toString());
        }

        private RuntimeException notImplemented(String msg, String info) {
            return new InvalidSemanticsException(msg + ": " + info);
        }

        private TransactionMode getTransactionMode(QueryType queryType, String graph) {
            FabricPlan.ExecutionType executionType = this.plan.executionType();
            AccessMode queryMode = EffectiveQueryType.effectiveAccessMode(this.accessMode, executionType, queryType);
            if (this.accessMode == AccessMode.WRITE) {
                if (queryMode == AccessMode.WRITE) {
                    return TransactionMode.DEFINITELY_WRITE;
                }
                return TransactionMode.MAYBE_WRITE;
            }
            if (queryMode == AccessMode.WRITE) {
                throw new FabricException((Status)Status.Statement.AccessMode, "Writing in read access mode not allowed. Attempted write to %s", graph);
            }
            return TransactionMode.DEFINITELY_READ;
        }
    }

    private static class FragmentResult {
        private final Flux<Record> records;
        private final Mono<ExecutionPlanDescription> planDescription;
        private final Mono<QueryExecutionType> executionType;

        FragmentResult(Flux<Record> records, Mono<ExecutionPlanDescription> planDescription, Mono<QueryExecutionType> executionType) {
            this.records = records;
            this.planDescription = planDescription;
            this.executionType = executionType;
        }
    }
}

