/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.fabric.bolt.QueryRouterBookmark;
import org.neo4j.fabric.bookmark.RemoteBookmark;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.PackstreamBuf;

public class BookmarkFormat {
    private static final String PREFIX = "FB:";

    public static List<QueryRouterBookmark> parse(List<String> customBookmarks) {
        return customBookmarks.stream().map(BookmarkFormat::parse).collect(Collectors.toList());
    }

    public static QueryRouterBookmark parse(String bookmarkString) {
        String content = bookmarkString.substring(PREFIX.length());
        if (content.isEmpty()) {
            return new QueryRouterBookmark(List.of(), List.of());
        }
        return BookmarkFormat.deserialize(content);
    }

    public static String serialize(QueryRouterBookmark queryRouterBookmark) {
        try {
            Packer packer = new Packer(queryRouterBookmark);
            String p = packer.pack();
            return PREFIX + p;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to serialize bookmark", exception);
        }
    }

    private static QueryRouterBookmark deserialize(String serializedBookmark) {
        try {
            Unpacker unpacker = new Unpacker(serializedBookmark);
            return unpacker.unpack();
        }
        catch (Exception exception) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N12).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
            throw new FabricException(gql, (Status)Status.Transaction.InvalidBookmark, "Parsing of supplied bookmarks failed with message: " + exception.getMessage(), exception);
        }
    }

    private static class Packer {
        final PackstreamBuf buf = PackstreamBuf.allocUnpooled();
        final QueryRouterBookmark queryRouterBookmark;

        Packer(QueryRouterBookmark queryRouterBookmark) {
            this.queryRouterBookmark = queryRouterBookmark;
        }

        String pack() throws IOException {
            this.packInternalGraphs(this.queryRouterBookmark.internalGraphStates());
            this.packExternalGraphs(this.queryRouterBookmark.externalGraphStates());
            byte[] heap = new byte[this.buf.getTarget().readableBytes()];
            this.buf.getTarget().readBytes(heap);
            return Base64.getEncoder().encodeToString(heap);
        }

        void packInternalGraphs(List<QueryRouterBookmark.InternalGraphState> internalGraphStates) {
            this.buf.writeList(internalGraphStates, this::packInternalGraph);
        }

        void packInternalGraph(PackstreamBuf buf, QueryRouterBookmark.InternalGraphState internalGraphState) {
            this.packUuid(buf, internalGraphState.graphUuid());
            buf.writeInt(internalGraphState.transactionId());
        }

        void packExternalGraphs(List<QueryRouterBookmark.ExternalGraphState> externalGraphStates) {
            this.buf.writeList(externalGraphStates, this::packExternalGraph);
        }

        void packExternalGraph(PackstreamBuf buf, QueryRouterBookmark.ExternalGraphState externalGraphState) {
            this.packUuid(buf, externalGraphState.graphUuid());
            buf.writeList(externalGraphState.bookmarks(), (b, bookmark) -> b.writeString(bookmark.serializedState()));
        }

        void packUuid(PackstreamBuf buf, UUID uuid) {
            buf.writeBytes(Unpooled.buffer((int)16).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits()));
        }
    }

    private static class Unpacker {
        final PackstreamBuf buf;

        Unpacker(String serializedBookmark) {
            byte[] bytes = Base64.getDecoder().decode(serializedBookmark);
            this.buf = PackstreamBuf.wrap((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes));
        }

        QueryRouterBookmark unpack() throws IOException {
            try {
                List<QueryRouterBookmark.InternalGraphState> internalGraphs = this.unpackInternalGraphs();
                List<QueryRouterBookmark.ExternalGraphState> externalGraphs = this.unpackExternalGraphs();
                return new QueryRouterBookmark(internalGraphs, externalGraphs);
            }
            catch (PackstreamReaderException ex) {
                throw new IOException(ex);
            }
        }

        List<QueryRouterBookmark.InternalGraphState> unpackInternalGraphs() throws IOException {
            return this.buf.readList(this::unpackInternalGraph);
        }

        QueryRouterBookmark.InternalGraphState unpackInternalGraph(PackstreamBuf buf) throws PackstreamReaderException {
            UUID graphUuid = this.unpackUuid(buf);
            long txId = buf.readInt();
            return new QueryRouterBookmark.InternalGraphState(graphUuid, txId);
        }

        List<QueryRouterBookmark.ExternalGraphState> unpackExternalGraphs() throws IOException {
            return this.buf.readList(this::unpackExternalGraph);
        }

        QueryRouterBookmark.ExternalGraphState unpackExternalGraph(PackstreamBuf buf) throws PackstreamReaderException {
            UUID graphUuid = this.unpackUuid(buf);
            List<RemoteBookmark> remoteBookmarks = buf.readList(PackstreamBuf::readString).stream().map(RemoteBookmark::new).collect(Collectors.toList());
            return new QueryRouterBookmark.ExternalGraphState(graphUuid, remoteBookmarks);
        }

        UUID unpackUuid(PackstreamBuf buf) throws PackstreamReaderException {
            ByteBuf uuidBytes = buf.readBytes();
            long high = uuidBytes.readLong();
            long low = uuidBytes.readLong();
            return new UUID(high, low);
        }
    }
}

