/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.evaluator.StaticEvaluation;
import org.neo4j.cypher.internal.expressions.AutoExtractedParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.EffectiveQueryType;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FragmentResult;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.QueryTypes;
import org.neo4j.fabric.executor.TaggingPlanDescriptionWrapper;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.FabricQuery;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.planning.QueryType;
import org.neo4j.fabric.stream.CompletionDelegatingOperator;
import org.neo4j.fabric.stream.Prefetcher;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.MergedQueryStatistics;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.notifications.StandardGqlStatusObject;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.jdk.javaapi.CollectionConverters;

abstract class SingleQueryFragmentExecutor {
    private final FabricPlanner.PlannerInstance plannerInstance;
    private final Executor fabricWorkerExecutor;
    private final FabricTransaction.FabricExecutionContext ctx;
    private final UseEvaluation.Instance useEvaluator;
    private final FabricPlan plan;
    private final MapValue queryParams;
    private final AccessMode accessMode;
    private final Set<Notification> notifications;
    private final Set<GqlStatusObject> gqlStatusObjects;
    private final QueryStatementLifecycles.StatementLifecycle lifecycle;
    private final Prefetcher prefetcher;
    private final QueryRoutingMonitor queryRoutingMonitor;
    private final MergedQueryStatistics statistics;
    private final Tracer tracer;
    private final FragmentExecutor fragmentExecutor;

    SingleQueryFragmentExecutor(FabricPlanner.PlannerInstance plannerInstance, Executor fabricWorkerExecutor, FabricTransaction.FabricExecutionContext ctx, UseEvaluation.Instance useEvaluator, FabricPlan plan, MapValue queryParams, AccessMode accessMode, Set<Notification> notifications, Set<GqlStatusObject> gqlStatusObjects, QueryStatementLifecycles.StatementLifecycle lifecycle, Prefetcher prefetcher, QueryRoutingMonitor queryRoutingMonitor, MergedQueryStatistics statistics, Tracer tracer, FragmentExecutor fragmentExecutor) {
        this.plannerInstance = plannerInstance;
        this.fabricWorkerExecutor = fabricWorkerExecutor;
        this.ctx = ctx;
        this.useEvaluator = useEvaluator;
        this.plan = plan;
        this.queryParams = queryParams;
        this.accessMode = accessMode;
        this.notifications = notifications;
        this.gqlStatusObjects = gqlStatusObjects;
        this.lifecycle = lifecycle;
        this.prefetcher = prefetcher;
        this.queryRoutingMonitor = queryRoutingMonitor;
        this.statistics = statistics;
        this.tracer = tracer;
        this.fragmentExecutor = fragmentExecutor;
    }

    MapValue queryParams() {
        return this.queryParams;
    }

    FabricTransaction.FabricExecutionContext ctx() {
        return this.ctx;
    }

    FragmentExecutor fragmentExecutor() {
        return this.fragmentExecutor;
    }

    PrepareResult prepare(Fragment.Exec fragment, Record argument) {
        this.ctx.validateStatementType(fragment.statementType());
        Map<String, AnyValue> argumentValues = this.argumentValues(fragment, argument);
        Catalog.Graph graph = this.evalUse(fragment.use().graphSelection(), argumentValues, this.ctx.getSessionDatabaseReference());
        this.validateCanUseGraph(graph, this.ctx.getSessionDatabaseReference());
        TransactionMode transactionMode = this.getTransactionMode(fragment.queryType(), graph.reference().toPrettyString());
        return new PrepareResult(graph, argumentValues, transactionMode);
    }

    FragmentResult doExecuteFragment(Fragment.Exec fragment, MapValue parameters, Catalog.Graph graph, TransactionMode transactionMode, Supplier<FragmentResult> executeFragmentInput) {
        Location location = this.ctx.locationOf(graph, transactionMode.requiresWrite());
        if (location instanceof Location.Local) {
            Location.Local local = (Location.Local)location;
            FragmentResult input = executeFragmentInput.get();
            if (fragment.executable()) {
                FabricQuery.LocalQuery localQuery = this.plannerInstance.asLocal(fragment);
                boolean targetsComposite = this.plannerInstance.targetsComposite(fragment);
                FragmentResult fragmentResult = this.runLocalQueryAt(local, transactionMode, localQuery.query(), parameters, targetsComposite, input.records());
                Mono<QueryExecutionType> executionType = this.mergeExecutionType(input.executionType(), fragmentResult.executionType());
                return new FragmentResult(fragmentResult.records(), fragmentResult.planDescription(), executionType);
            }
            return input;
        }
        if (location instanceof Location.Remote) {
            Location.Remote remote = (Location.Remote)location;
            FabricQuery.RemoteQuery remoteQuery = this.plannerInstance.asRemote(fragment);
            Map extracted = CollectionConverters.asJava(remoteQuery.extractedLiterals());
            MapValueBuilder builder = new MapValueBuilder();
            StaticEvaluation.StaticEvaluator evaluator = this.useEvaluator.evaluator();
            for (Map.Entry entry : extracted.entrySet()) {
                builder.add(((AutoExtractedParameter)entry.getKey()).name(), evaluator.evaluate((Expression)entry.getValue(), VirtualValues.EMPTY_MAP, CypherRow.empty()));
            }
            MapValue fullParams = parameters.updatedWith(builder.build());
            return this.runRemoteQueryAt(remote, transactionMode, remoteQuery.query(), fullParams);
        }
        throw this.notImplemented("Invalid graph location", location);
    }

    abstract Mono<StatementResult> runRemote(Location.Remote var1, ExecutionOptions var2, String var3, TransactionMode var4, MapValue var5);

    abstract StatementResult runLocal(Location.Local var1, TransactionMode var2, QueryStatementLifecycles.StatementLifecycle var3, FullyParsedQuery var4, MapValue var5, Flux<Record> var6, ExecutionOptions var7, Boolean var8);

    private RuntimeException notImplemented(String msg, Object object) {
        return this.notImplemented(msg, object.toString());
    }

    private RuntimeException notImplemented(String msg, String info) {
        return new InvalidSemanticsException(msg + ": " + info);
    }

    private FragmentResult runRemoteQueryAt(Location.Remote location, TransactionMode transactionMode, String queryString, MapValue parameters) {
        RecordTracer recordTracer = this.tracer.remoteQueryStart(location, queryString);
        ExecutionOptions executionOptions = this.plan.inCompositeContext() ? new ExecutionOptions(location.graphId()) : new ExecutionOptions();
        this.lifecycle.startExecution(true);
        Mono<StatementResult> statementResult = this.runRemote(location, executionOptions, queryString, transactionMode, parameters);
        Flux records = statementResult.flatMapMany(sr -> sr.records().doOnComplete(() -> sr.summary().subscribe(this::updateSummary)));
        CompletionDelegatingOperator recordsWithCompletionDelegation = new CompletionDelegatingOperator((Flux<Record>)records, this.fabricWorkerExecutor);
        Flux<Record> prefetchedRecords = this.prefetcher.addPrefetch((Flux<Record>)recordsWithCompletionDelegation);
        Mono planDescription = statementResult.flatMap(StatementResult::summary).map(Summary::executionPlanDescription);
        Mono executionType = Mono.just((Object)EffectiveQueryType.queryExecutionType(this.plan, this.accessMode));
        if (location instanceof Location.Remote.Internal) {
            this.queryRoutingMonitor.queryRoutedRemoteInternal();
        } else if (location instanceof Location.Remote.External) {
            this.queryRoutingMonitor.queryRoutedRemoteExternal();
        }
        return recordTracer.traceRecords(new FragmentResult(prefetchedRecords, (Mono<ExecutionPlanDescription>)planDescription, (Mono<QueryExecutionType>)executionType));
    }

    private FragmentResult runLocalQueryAt(Location.Local location, TransactionMode transactionMode, FullyParsedQuery query, MapValue parameters, boolean targetsComposite, Flux<Record> input) {
        RecordTracer recordTracer = this.tracer.localQueryStart(location, query);
        ExecutionOptions executionOptions = this.plan.inCompositeContext() && !targetsComposite ? new ExecutionOptions(location.graphId()) : new ExecutionOptions();
        StatementResult localStatementResult = this.runLocal(location, transactionMode, this.lifecycle, query, parameters, input, executionOptions, targetsComposite);
        Flux records = localStatementResult.records().doOnComplete(() -> localStatementResult.summary().subscribe(this::updateSummary));
        Mono planDescription = localStatementResult.summary().map(Summary::executionPlanDescription).map(pd -> new TaggingPlanDescriptionWrapper((ExecutionPlanDescription)pd, location.getDatabaseName()));
        this.queryRoutingMonitor.queryRoutedLocal();
        return recordTracer.traceRecords(new FragmentResult((Flux<Record>)records, (Mono<ExecutionPlanDescription>)planDescription, localStatementResult.executionType()));
    }

    private Map<String, AnyValue> argumentValues(Fragment fragment, Record argument) {
        if (argument == null) {
            return Map.of();
        }
        return Records.asMap(argument, CollectionConverters.asJava(fragment.argumentColumns()));
    }

    private Catalog.Graph evalUse(GraphSelection selection, Map<String, AnyValue> record, DatabaseReference sessionDb) {
        return this.useEvaluator.evaluate(selection, this.queryParams, record, sessionDb);
    }

    private void validateCanUseGraph(Catalog.Graph accessedGraph, DatabaseReference sessionDatabaseReference) {
        Catalog.Graph sessionGraph = this.useEvaluator.resolveGraph(sessionDatabaseReference.alias());
        if (sessionGraph instanceof Catalog.Composite) {
            if (!this.useEvaluator.isConstituentOrSelf(accessedGraph, sessionGraph) && !this.useEvaluator.isSystem(accessedGraph)) {
                throw new InvalidSemanticsException(this.cantAccessOutsideCompositeMessage(sessionGraph, accessedGraph));
            }
        } else if (!this.useEvaluator.isDatabaseOrAliasInRoot(accessedGraph)) {
            throw new InvalidSemanticsException(this.cantAccessCompositeConstituentsMessage(sessionGraph, accessedGraph));
        }
    }

    private String cantAccessOutsideCompositeMessage(Catalog.Graph sessionDatabase, Catalog.Graph accessed) {
        return "When connected to a composite database, access is allowed only to its constituents. " + "Attempted to access '%s' while connected to '%s'".formatted(this.useEvaluator.qualifiedNameString(accessed), this.useEvaluator.qualifiedNameString(sessionDatabase));
    }

    private String cantAccessCompositeConstituentsMessage(Catalog.Graph sessionDatabase, Catalog.Graph accessed) {
        return "Accessing a composite database and its constituents is only allowed when connected to it. " + "Attempted to access '%s' while connected to '%s'".formatted(this.useEvaluator.qualifiedNameString(accessed), this.useEvaluator.qualifiedNameString(sessionDatabase));
    }

    private TransactionMode getTransactionMode(QueryType queryType, String graph) {
        FabricPlan.ExecutionType executionType = this.plan.executionType();
        AccessMode queryMode = EffectiveQueryType.effectiveAccessMode(this.accessMode, executionType, queryType);
        if (this.accessMode == AccessMode.WRITE) {
            if (queryMode == AccessMode.WRITE) {
                return TransactionMode.DEFINITELY_WRITE;
            }
            return TransactionMode.MAYBE_WRITE;
        }
        if (queryMode == AccessMode.WRITE) {
            throw new FabricException((Status)Status.Statement.AccessMode, "Writing in read access mode not allowed. Attempted write to %s", graph);
        }
        return TransactionMode.DEFINITELY_READ;
    }

    AnyValue validateValue(AnyValue value) {
        if (value instanceof VirtualNodeValue) {
            throw new FabricException((Status)Status.Statement.TypeError, "Importing node values in remote subqueries is currently not supported", new Object[0]);
        }
        if (value instanceof VirtualRelationshipValue) {
            throw new FabricException((Status)Status.Statement.TypeError, "Importing relationship values in remote subqueries is currently not supported", new Object[0]);
        }
        if (value instanceof PathValue) {
            throw new FabricException((Status)Status.Statement.TypeError, "Importing path values in remote subqueries is currently not supported", new Object[0]);
        }
        return value;
    }

    private Mono<QueryExecutionType> mergeExecutionType(Mono<QueryExecutionType> lhs, Mono<QueryExecutionType> rhs) {
        return Mono.zip(lhs, rhs).map(both -> QueryTypes.merge((QueryExecutionType)both.getT1(), (QueryExecutionType)both.getT2())).switchIfEmpty(lhs).switchIfEmpty(rhs);
    }

    private void updateSummary(Summary summary) {
        if (summary != null) {
            this.statistics.add(summary.getQueryStatistics());
            this.notifications.addAll(summary.getNotifications());
            this.mergeGqlStatusObjects(summary.getGqlStatusObjects());
        }
    }

    private void mergeGqlStatusObjects(Collection<GqlStatusObject> newGqlStatusObjects) {
        this.gqlStatusObjects.removeIf(gso -> StandardGqlStatusObject.isStandardGqlStatusCode((String)gso.gqlStatus()));
        this.gqlStatusObjects.addAll(newGqlStatusObjects);
    }

    static interface Tracer {
        public RecordTracer remoteQueryStart(Location.Remote var1, String var2);

        public RecordTracer localQueryStart(Location.Local var1, FullyParsedQuery var2);
    }

    static interface FragmentExecutor {
        public FragmentResult run(Fragment var1, Record var2);
    }

    record PrepareResult(Catalog.Graph graph, Map<String, AnyValue> argumentValues, TransactionMode transactionMode) {
    }

    static interface RecordTracer {
        public FragmentResult traceRecords(FragmentResult var1);
    }
}

