/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction.parent;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.fabric.transaction.parent.ChildTransaction;
import org.neo4j.fabric.transaction.parent.CompoundTransaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.time.SystemNanoClock;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractCompoundTransaction<Child extends ChildTransaction>
implements CompoundTransaction<Child> {
    private final ErrorReporter errorReporter;
    private final SystemNanoClock clock;
    private final ReadWriteLock transactionLock = new ReentrantReadWriteLock();
    protected final Lock nonExclusiveLock = this.transactionLock.readLock();
    protected final Lock exclusiveLock = this.transactionLock.writeLock();
    protected State state = State.OPEN;
    protected TerminationMark terminationMark;
    private final Set<CompoundTransaction.AutocommitQuery> autocommitQueries = ConcurrentHashMap.newKeySet();
    protected final Set<ReadingChildTransaction<Child>> readingTransactions = ConcurrentHashMap.newKeySet();
    protected Child writingTransaction;

    protected AbstractCompoundTransaction(ErrorReporter errorReporter, SystemNanoClock clock) {
        this.errorReporter = errorReporter;
        this.clock = clock;
    }

    @Override
    public <Tx extends Child> Tx registerNewChildTransaction(Location location, TransactionMode mode, Supplier<Tx> transactionSupplier) throws FabricException {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionMode.DEFINITELY_WRITE -> this.startWritingTransaction(location, transactionSupplier);
            case TransactionMode.MAYBE_WRITE -> this.startReadingTransaction(false, transactionSupplier);
            case TransactionMode.DEFINITELY_READ -> this.startReadingTransaction(true, transactionSupplier);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Tx extends Child> Tx startWritingTransaction(Location location, Supplier<Tx> writeTransactionSupplier) throws FabricException {
        this.exclusiveLock.lock();
        try {
            this.checkTransactionOpenForStatementExecution();
            if (this.writingTransaction != null) {
                throw this.multipleWriteError(location, this.writingTransaction.location());
            }
            ChildTransaction tx = (ChildTransaction)writeTransactionSupplier.get();
            this.writingTransaction = tx;
            ChildTransaction childTransaction = tx;
            return (Tx)childTransaction;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TX extends Child> TX startReadingTransaction(boolean readOnly, Supplier<TX> readingTransactionSupplier) throws FabricException {
        this.nonExclusiveLock.lock();
        try {
            this.checkTransactionOpenForStatementExecution();
            ChildTransaction tx = (ChildTransaction)readingTransactionSupplier.get();
            this.readingTransactions.add(new ReadingChildTransaction<ChildTransaction>(tx, readOnly));
            ChildTransaction childTransaction = tx;
            return (TX)childTransaction;
        }
        finally {
            this.nonExclusiveLock.unlock();
        }
    }

    @Override
    public <Tx extends Child> void upgradeToWritingTransaction(Tx childTransaction) throws FabricException {
        if (this.writingTransaction == childTransaction) {
            return;
        }
        this.exclusiveLock.lock();
        try {
            if (this.writingTransaction == childTransaction) {
                return;
            }
            if (this.writingTransaction != null) {
                throw this.multipleWriteError(childTransaction.location(), this.writingTransaction.location());
            }
            ReadingChildTransaction readingTransaction = this.readingTransactions.stream().filter(readingTx -> readingTx.inner == childTransaction).findAny().orElseThrow(() -> new IllegalArgumentException("The supplied transaction has not been registered"));
            if (readingTransaction.readingOnly) {
                throw new IllegalStateException("Upgrading reading-only transaction to a writing one is not allowed");
            }
            this.readingTransactions.remove(readingTransaction);
            this.writingTransaction = (ChildTransaction)readingTransaction.inner;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.exclusiveLock.lock();
        try {
            if (this.state == State.TERMINATED) {
                this.doRollbackAndIgnoreErrors(this::childTransactionRollback);
                throw new TransactionTerminatedException(this.terminationMark.getReason());
            }
            if (this.state == State.CLOSED) {
                throw new FabricException((Status)Status.Transaction.TransactionCommitFailed, "Trying to commit closed transaction", new Object[0]);
            }
            this.state = State.CLOSED;
            ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
            try {
                this.doOnChildren(this.readingTransactions, null, this::childTransactionCommit).forEach(error -> allFailures.add(new ErrorRecord("Failed to commit a child read transaction", (Throwable)error)));
                if (!allFailures.isEmpty()) {
                    this.doOnChildren(List.of(), this.writingTransaction, this::childTransactionRollback).forEach(error -> allFailures.add(new ErrorRecord("Failed to rollback a child write transaction", (Throwable)error)));
                } else {
                    this.doOnChildren(List.of(), this.writingTransaction, this::childTransactionCommit).forEach(error -> allFailures.add(new ErrorRecord("Failed to commit a child write transaction", (Throwable)error)));
                }
            }
            catch (Exception e) {
                allFailures.add(new ErrorRecord("Failed to commit composite transaction", (Throwable)((Object)this.commitFailedError())));
            }
            finally {
                this.closeContextsAndRemoveTransaction();
            }
            this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionCommitFailed);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public void rollback() {
        this.exclusiveLock.lock();
        try {
            if (this.isUninitialized()) {
                return;
            }
            if (this.state == State.TERMINATED) {
                this.doRollbackAndIgnoreErrors(this::childTransactionRollback);
                return;
            }
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
            this.doRollback(this::childTransactionRollback);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback(Function<Child, Mono<Void>> operation) {
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, operation).forEach(error -> allFailures.add(new ErrorRecord("Failed to rollback a child transaction", (Throwable)error)));
        }
        catch (Exception e) {
            allFailures.add(new ErrorRecord("Failed to rollback composite transaction", (Throwable)((Object)this.rollbackFailedError())));
        }
        finally {
            this.closeContextsAndRemoveTransaction();
        }
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionRollbackFailed);
    }

    private void doRollbackAndIgnoreErrors(Function<Child, Mono<Void>> operation) {
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, operation);
        }
        finally {
            this.closeContextsAndRemoveTransaction();
        }
    }

    @Override
    public boolean markForTermination(Status reason) {
        try {
            do {
                if (this.state == State.OPEN) continue;
                return false;
            } while (!this.exclusiveLock.tryLock(100L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            throw this.terminationFailedError();
        }
        try {
            if (this.state != State.OPEN) {
                boolean bl = false;
                return bl;
            }
            this.terminationMark = new TerminationMark(reason, this.clock.nanos());
            this.state = State.TERMINATED;
            this.terminateChildren(reason);
            this.autocommitQueries.forEach(q -> q.terminate(reason));
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return true;
    }

    @Override
    public void childTransactionTerminated(Status reason) {
        if (!this.isOpen()) {
            return;
        }
        this.markForTermination(reason);
    }

    @Override
    public void registerAutocommitQuery(CompoundTransaction.AutocommitQuery autocommitQuery) {
        this.autocommitQueries.add(autocommitQuery);
        if (this.state == State.TERMINATED) {
            autocommitQuery.terminate(this.terminationMark.getReason());
        }
    }

    @Override
    public void unRegisterAutocommitQuery(CompoundTransaction.AutocommitQuery autocommitQuery) {
        this.autocommitQueries.remove(autocommitQuery);
    }

    private void terminateChildren(Status reason) {
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, singleDbTransaction -> this.childTransactionTerminate(singleDbTransaction, reason)).forEach(error -> allFailures.add(new ErrorRecord("Failed to terminate a child transaction", (Throwable)error)));
        }
        catch (Exception e) {
            allFailures.add(new ErrorRecord("Failed to terminate composite transaction", (Throwable)((Object)this.terminationFailedError())));
        }
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionTerminationFailed);
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public Optional<TerminationMark> getTerminationMark() {
        return Optional.ofNullable(this.terminationMark);
    }

    protected void checkTransactionOpenForStatementExecution() throws FabricException {
        if (this.state == State.TERMINATED) {
            throw new TransactionTerminatedException(this.terminationMark.getReason());
        }
        if (this.state == State.CLOSED) {
            throw FabricException.executeQueryInClosedTransaction();
        }
    }

    private List<Throwable> doOnChildren(Iterable<ReadingChildTransaction<Child>> readingTransactions, Child writingTransaction, Function<Child, Mono<Void>> operation) {
        List failures = (List)Flux.fromIterable(readingTransactions).map(txWrapper -> (ChildTransaction)txWrapper.inner).concatWith((Publisher)Mono.justOrEmpty(writingTransaction)).flatMap(tx -> this.catchErrors((Mono<Void>)((Mono)operation.apply(tx)))).collectList().block();
        return failures == null ? List.of() : failures;
    }

    private Mono<Throwable> catchErrors(Mono<Void> action) {
        return action.flatMap(v -> Mono.empty()).onErrorResume(Mono::just);
    }

    private void throwIfNonEmpty(List<ErrorRecord> failures, Status defaultStatusCode) {
        if (!failures.isEmpty()) {
            RuntimeException mainException = Exceptions.transform(defaultStatusCode, failures.get((int)0).error);
            for (int i = 1; i < failures.size(); ++i) {
                ErrorRecord errorRecord = failures.get(i);
                mainException.addSuppressed(errorRecord.error);
                this.errorReporter.report(errorRecord.message, errorRecord.error, defaultStatusCode);
            }
            throw mainException;
        }
    }

    private FabricException multipleWriteError(Location attempt, Location current) {
        if (current.getUuid().equals(attempt.getUuid())) {
            return FabricException.writeDuringLeaderSwitch(attempt, current);
        }
        return new FabricException((Status)Status.Statement.AccessMode, "Writing to more than one database per transaction is not allowed. Attempted write to %s, currently writing to %s", attempt.databaseReference().toPrettyString(), current.databaseReference().toPrettyString());
    }

    private FabricException commitFailedError() {
        return new FabricException((Status)Status.Transaction.TransactionCommitFailed, "Failed to commit composite transaction", new Object[0]);
    }

    private FabricException rollbackFailedError() {
        return new FabricException((Status)Status.Transaction.TransactionRollbackFailed, "Failed to rollback composite transaction", new Object[0]);
    }

    private FabricException terminationFailedError() {
        return new FabricException((Status)Status.Transaction.TransactionTerminationFailed, "Failed to terminate composite transaction", new Object[0]);
    }

    protected abstract boolean isUninitialized();

    protected abstract void closeContextsAndRemoveTransaction();

    protected abstract Mono<Void> childTransactionCommit(Child var1);

    protected abstract Mono<Void> childTransactionRollback(Child var1);

    protected abstract Mono<Void> childTransactionTerminate(Child var1, Status var2);

    protected static enum State {
        OPEN,
        CLOSED,
        TERMINATED;

    }

    private record ReadingChildTransaction<Tx>(Tx inner, boolean readingOnly) {
    }

    protected record ErrorRecord(String message, Throwable error) {
    }
}

