/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public interface Location {
    public DatabaseReference databaseReference();

    public long graphId();

    public String getDatabaseName();

    default public UUID getUuid() {
        return this.databaseReference().id();
    }

    public static interface Remote
    extends Location {

        public static final class External
        extends Record
        implements Remote {
            private final long graphId;
            private final DatabaseReferenceImpl.External databaseReference;

            public External(long graphId, DatabaseReferenceImpl.External databaseReference) {
                this.graphId = graphId;
                this.databaseReference = databaseReference;
            }

            @Override
            public String getDatabaseName() {
                return this.databaseReference.targetAlias().name();
            }

            public RemoteUri getUri() {
                return this.databaseReference.externalUri();
            }

            public String locationName() {
                return this.databaseReference.alias().name();
            }

            public Optional<String> locationNamespace() {
                return this.databaseReference.namespace().map(NormalizedDatabaseName::name);
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{External.class, "graphId;databaseReference", "graphId", "databaseReference"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{External.class, "graphId;databaseReference", "graphId", "databaseReference"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{External.class, "graphId;databaseReference", "graphId", "databaseReference"}, this, o);
            }

            @Override
            public long graphId() {
                return this.graphId;
            }

            public DatabaseReferenceImpl.External databaseReference() {
                return this.databaseReference;
            }
        }

        public static interface Internal
        extends Remote {

            public static final class Direct
            extends Record
            implements Internal {
                private final long graphId;
                private final DatabaseReferenceImpl.Internal databaseReference;
                private final RemoteUri uri;

                public Direct(long graphId, DatabaseReferenceImpl.Internal databaseReference, RemoteUri uri) {
                    this.graphId = graphId;
                    this.databaseReference = databaseReference;
                    this.uri = uri;
                }

                @Override
                public String getDatabaseName() {
                    return this.databaseReference.databaseId().name();
                }

                public RemoteUri getUri() {
                    return this.uri;
                }

                @Override
                public final String toString() {
                    return ObjectMethods.bootstrap("toString", new MethodHandle[]{Direct.class, "graphId;databaseReference;uri", "graphId", "databaseReference", "uri"}, this);
                }

                @Override
                public final int hashCode() {
                    return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Direct.class, "graphId;databaseReference;uri", "graphId", "databaseReference", "uri"}, this);
                }

                @Override
                public final boolean equals(Object o) {
                    return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Direct.class, "graphId;databaseReference;uri", "graphId", "databaseReference", "uri"}, this, o);
                }

                @Override
                public long graphId() {
                    return this.graphId;
                }

                public DatabaseReferenceImpl.Internal databaseReference() {
                    return this.databaseReference;
                }

                public RemoteUri uri() {
                    return this.uri;
                }
            }

            public static final class Routing
            extends Record
            implements Internal {
                private final long graphId;
                private final DatabaseReferenceImpl.Internal databaseReference;

                public Routing(long graphId, DatabaseReferenceImpl.Internal databaseReference) {
                    this.graphId = graphId;
                    this.databaseReference = databaseReference;
                }

                @Override
                public String getDatabaseName() {
                    return this.databaseReference.databaseId().name();
                }

                @Override
                public final String toString() {
                    return ObjectMethods.bootstrap("toString", new MethodHandle[]{Routing.class, "graphId;databaseReference", "graphId", "databaseReference"}, this);
                }

                @Override
                public final int hashCode() {
                    return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Routing.class, "graphId;databaseReference", "graphId", "databaseReference"}, this);
                }

                @Override
                public final boolean equals(Object o) {
                    return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Routing.class, "graphId;databaseReference", "graphId", "databaseReference"}, this, o);
                }

                @Override
                public long graphId() {
                    return this.graphId;
                }

                public DatabaseReferenceImpl.Internal databaseReference() {
                    return this.databaseReference;
                }
            }
        }
    }

    public static final class Local
    extends Record
    implements Location {
        private final long graphId;
        private final DatabaseReferenceImpl.Internal databaseReference;

        public Local(long graphId, DatabaseReferenceImpl.Internal databaseReference) {
            this.graphId = graphId;
            this.databaseReference = databaseReference;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseReference.databaseId().name();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Local.class, "graphId;databaseReference", "graphId", "databaseReference"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Local.class, "graphId;databaseReference", "graphId", "databaseReference"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Local.class, "graphId;databaseReference", "graphId", "databaseReference"}, this, o);
        }

        @Override
        public long graphId() {
            return this.graphId;
        }

        public DatabaseReferenceImpl.Internal databaseReference() {
            return this.databaseReference;
        }
    }
}

