/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.List;
import java.util.function.Consumer;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.QueryExecutionType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FabricExecutionStatementResultImpl
implements StatementResult {
    private final StatementResult statementResult;
    private final Consumer<Throwable> failureHandler;

    FabricExecutionStatementResultImpl(StatementResult statementResult, Consumer<Throwable> failureHandler) {
        this.statementResult = statementResult;
        this.failureHandler = failureHandler;
    }

    @Override
    public List<String> columns() {
        return this.statementResult.columns();
    }

    @Override
    public Flux<Record> records() {
        return this.statementResult.records().doOnError(this.failureHandler);
    }

    @Override
    public Mono<Summary> summary() {
        return this.statementResult.summary().doOnError(this.failureHandler);
    }

    @Override
    public Mono<QueryExecutionType> executionType() {
        return this.statementResult.executionType().doOnError(this.failureHandler);
    }
}

