/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.cypher.internal.CypherDeprecationNotificationsProvider;
import org.neo4j.cypher.internal.CypherQueryObfuscator;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.transaction.StatementLifecycleTransactionInfo;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.DeprecationNotificationsProvider;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryFactory;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.HeapHighWaterMarkTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class QueryStatementLifecycles {
    private final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;
    private final QueryExecutionMonitor dbmsMonitor;
    private final ExecutingQueryFactory executingQueryFactory;

    public QueryStatementLifecycles(DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, Monitors dbmsMonitors, Config config, LockTracer systemLockTracer, SystemNanoClock systemNanoClock) {
        this.databaseContextProvider = databaseContextProvider;
        this.dbmsMonitor = (QueryExecutionMonitor)dbmsMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.executingQueryFactory = new ExecutingQueryFactory(systemNanoClock, QueryStatementLifecycles.setupCpuClockAtomicReference(config), systemLockTracer);
    }

    private static AtomicReference<CpuClock> setupCpuClockAtomicReference(Config config) {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        SettingChangeListener cpuClockUpdater = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        cpuClockUpdater.accept(null, (Object)((Boolean)config.get(GraphDatabaseSettings.track_query_cpu_time)));
        config.addListener(GraphDatabaseSettings.track_query_cpu_time, cpuClockUpdater);
        return cpuClock;
    }

    public StatementLifecycle create(StatementLifecycleTransactionInfo transactionInfo, String statement, MapValue params, ExecutingQuery.TransactionBinding transactionBinding) {
        ExecutingQuery executingQuery = this.executingQueryFactory.createUnbound(statement, params, transactionInfo.getClientConnectionInfo(), transactionInfo.getLoginContext().subject().executingUser(), transactionInfo.getLoginContext().subject().authenticatedUser(), transactionInfo.getTxMetadata());
        if (transactionBinding != null) {
            executingQuery.onTransactionBound(transactionBinding);
        }
        return new StatementLifecycle(executingQuery);
    }

    public class StatementLifecycle {
        private final ExecutingQuery executingQuery;
        private QueryExecutionMonitor dbMonitor;
        private MonitoringMode monitoringMode;

        private StatementLifecycle(ExecutingQuery executingQuery) {
            this.executingQuery = executingQuery;
        }

        public void startProcessing() {
            this.getQueryExecutionMonitor().startProcessing(this.executingQuery);
        }

        public void doneFabricProcessing(FabricPlan plan, int preParserOffset) {
            this.executingQuery.onObfuscatorReady(CypherQueryObfuscator.apply((ObfuscationMetadata)plan.obfuscationMetadata()), preParserOffset);
            this.executingQuery.onFabricDeprecationNotificationsProviderReady((DeprecationNotificationsProvider)plan.deprecationNotificationsProvider());
            this.monitoringMode = plan.inCompositeContext() ? new ParentChildMonitoringMode() : new SingleQueryMonitoringMode();
        }

        public void doneRouterProcessing(ObfuscationMetadata obfuscateMetadata, InputPosition preParserOffset, boolean inCompositeContext, Set<InternalNotification> notifications) {
            this.executingQuery.onObfuscatorReady(CypherQueryObfuscator.apply((ObfuscationMetadata)obfuscateMetadata), preParserOffset.offset());
            this.executingQuery.onFabricDeprecationNotificationsProviderReady((DeprecationNotificationsProvider)CypherDeprecationNotificationsProvider.fromJava((InputPosition)preParserOffset, notifications));
            this.monitoringMode = inCompositeContext ? new ParentChildMonitoringMode() : new SingleQueryMonitoringMode();
        }

        public void startExecution(boolean shouldLogIfSingleQuery) {
            this.monitoringMode.startExecution(shouldLogIfSingleQuery);
        }

        public void endSuccess() {
            QueryExecutionMonitor monitor = this.getQueryExecutionMonitor();
            monitor.beforeEnd(this.executingQuery, true);
            monitor.endSuccess(this.executingQuery);
        }

        public void endFailure(Throwable failure) {
            QueryExecutionMonitor monitor = this.getQueryExecutionMonitor();
            Status status = failure instanceof Status.HasStatus ? ((Status.HasStatus)failure).status() : null;
            ErrorGqlStatusObject errorGqlStatusObject = failure instanceof ErrorGqlStatusObject ? (ErrorGqlStatusObject)failure : null;
            monitor.beforeEnd(this.executingQuery, false);
            monitor.endFailure(this.executingQuery, failure.getMessage(), status, errorGqlStatusObject);
        }

        private QueryExecutionMonitor getQueryExecutionMonitor() {
            return this.getDbMonitor().orElse(QueryStatementLifecycles.this.dbmsMonitor);
        }

        private Optional<QueryExecutionMonitor> getDbMonitor() {
            if (this.dbMonitor == null) {
                this.executingQuery.databaseId().flatMap(arg_0 -> QueryStatementLifecycles.this.databaseContextProvider.getDatabaseContext(arg_0)).map(dbm -> (Monitors)dbm.dependencies().resolveDependency(Monitors.class)).map(monitors -> (QueryExecutionMonitor)monitors.newMonitor(QueryExecutionMonitor.class, new String[0])).ifPresent(monitor -> {
                    this.dbMonitor = monitor;
                });
            }
            return Optional.ofNullable(this.dbMonitor);
        }

        public ExecutingQuery getMonitoredQuery() {
            return this.executingQuery;
        }

        QueryExecutionMonitor getChildQueryMonitor() {
            return this.monitoringMode.getChildQueryMonitor();
        }

        boolean isParentChildMonitoringMode() {
            return this.monitoringMode.isParentChildMonitoringMode();
        }

        private class ParentChildMonitoringMode
        extends MonitoringMode {
            private ParentChildMonitoringMode() {
            }

            @Override
            boolean isParentChildMonitoringMode() {
                return true;
            }

            @Override
            void startExecution(Boolean shouldLogIfSingleQuery) {
                if (!shouldLogIfSingleQuery.booleanValue()) {
                    StatementLifecycle.this.getQueryExecutionMonitor().startExecution(StatementLifecycle.this.executingQuery);
                    StatementLifecycle.this.executingQuery.onCompilationCompleted(null, null, null, 0);
                    StatementLifecycle.this.executingQuery.onExecutionStarted(HeapHighWaterMarkTracker.NONE);
                }
            }

            @Override
            QueryExecutionMonitor getChildQueryMonitor() {
                return StatementLifecycle.this.getQueryExecutionMonitor();
            }
        }

        private static abstract class MonitoringMode {
            private MonitoringMode() {
            }

            abstract boolean isParentChildMonitoringMode();

            abstract QueryExecutionMonitor getChildQueryMonitor();

            abstract void startExecution(Boolean var1);
        }

        private class SingleQueryMonitoringMode
        extends MonitoringMode {
            private SingleQueryMonitoringMode() {
            }

            @Override
            boolean isParentChildMonitoringMode() {
                return false;
            }

            @Override
            void startExecution(Boolean shouldLogIfSingleQuery) {
                if (shouldLogIfSingleQuery.booleanValue()) {
                    StatementLifecycle.this.getQueryExecutionMonitor().startExecution(StatementLifecycle.this.executingQuery);
                }
            }

            @Override
            QueryExecutionMonitor getChildQueryMonitor() {
                return QueryExecutionMonitor.NO_OP;
            }
        }
    }
}

