/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class FabricDatabaseManager {
    protected final FabricConfig fabricConfig;
    protected final DatabaseReferenceRepository databaseReferenceRepo;
    protected final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;
    private final boolean multiGraphEverywhere;

    public FabricDatabaseManager(FabricConfig fabricConfig, DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, DatabaseReferenceRepository databaseReferenceRepo) {
        this.fabricConfig = fabricConfig;
        this.databaseContextProvider = databaseContextProvider;
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.multiGraphEverywhere = fabricConfig.isEnabledByDefault();
    }

    public static boolean fabricByDefault(Config config) {
        return true;
    }

    public DatabaseReferenceRepository databaseReferenceRepository() {
        return this.databaseReferenceRepo;
    }

    public boolean hasMultiGraphCapabilities(String databaseNameRaw) {
        return this.multiGraphCapabilitiesEnabledForAllDatabases() || this.isFabricDatabase(databaseNameRaw);
    }

    public boolean multiGraphCapabilitiesEnabledForAllDatabases() {
        return this.multiGraphEverywhere;
    }

    public DatabaseReference getDatabaseReference(String databaseNameRaw) {
        return (DatabaseReference)this.databaseReferenceRepo.getByAlias(databaseNameRaw).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
    }

    public GraphDatabaseAPI getDatabaseFacade(String databaseNameRaw) throws UnavailableException {
        DatabaseContext databaseContext = this.getDatabaseContext(databaseNameRaw);
        databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        return databaseContext.databaseFacade();
    }

    private DatabaseContext getDatabaseContext(String databaseNameRaw) {
        return (DatabaseContext)this.databaseReferenceRepo.getInternalByAlias(databaseNameRaw).map(DatabaseReference.Internal::databaseId).flatMap(arg_0 -> this.databaseContextProvider.getDatabaseContext(arg_0)).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> new DatabaseNotFoundException("Database " + databaseNameRaw + " not found");
    }

    private static Supplier<UnavailableException> unavailable(String databaseNameRaw) {
        return () -> new UnavailableException("Database " + databaseNameRaw + " is not available on current server");
    }

    private void assertInternalDatabaseAvailable(DatabaseReference.Internal databaseReference) throws UnavailableException {
        DatabaseContext ctx = (DatabaseContext)this.databaseContextProvider.getDatabaseContext(databaseReference.databaseId()).orElseThrow(FabricDatabaseManager.unavailable(databaseReference.alias().name()));
        ctx.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
    }

    public boolean isFabricDatabase(String databaseNameRaw) {
        return false;
    }

    public boolean isFabricDatabase(NamedDatabaseId databaseId2) {
        return false;
    }

    public FabricConfig getFabricConfig() {
        return this.fabricConfig;
    }
}

