/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.neo4j.bolt.dbapi.BookmarkMetadata;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.fabric.bookmark.BookmarkStateSerializer;
import org.neo4j.fabric.bookmark.RemoteBookmark;
import org.neo4j.kernel.database.NamedDatabaseId;

public class FabricBookmark
extends BookmarkMetadata
implements Bookmark {
    public static final String PREFIX = "FB:";
    private final List<InternalGraphState> internalGraphStates;
    private final List<ExternalGraphState> externalGraphStates;

    public FabricBookmark(List<InternalGraphState> internalGraphStates, List<ExternalGraphState> externalGraphStates) {
        super(-1L, null);
        this.internalGraphStates = internalGraphStates;
        this.externalGraphStates = externalGraphStates;
    }

    public List<InternalGraphState> getInternalGraphStates() {
        return this.internalGraphStates;
    }

    public List<ExternalGraphState> getExternalGraphStates() {
        return this.externalGraphStates;
    }

    public long txId() {
        return this.getTxId();
    }

    public NamedDatabaseId databaseId() {
        return this.getNamedDatabaseId();
    }

    public void attachTo(ResponseHandler state) {
        state.onBookmark(this.serialize());
    }

    public Bookmark toBookmark(BiFunction<Long, NamedDatabaseId, Bookmark> defaultBookmarkFormat) {
        return this;
    }

    public String serialize() {
        String serializedState = BookmarkStateSerializer.serialize(this);
        return PREFIX + serializedState;
    }

    public static FabricBookmark merge(List<FabricBookmark> fabricBookmarks) {
        List<InternalGraphState> mergedInternalGraphStates = FabricBookmark.mergeInternalGraphStates(fabricBookmarks);
        List<ExternalGraphState> mergedExternalGraphStates = FabricBookmark.mergeExternalGraphStates(fabricBookmarks);
        return new FabricBookmark(mergedInternalGraphStates, mergedExternalGraphStates);
    }

    private static List<InternalGraphState> mergeInternalGraphStates(List<FabricBookmark> fabricBookmarks) {
        HashMap internalGraphTxIds = new HashMap();
        fabricBookmarks.stream().flatMap(fabricBookmark -> fabricBookmark.getInternalGraphStates().stream()).forEach(internalGraphState -> internalGraphTxIds.merge(internalGraphState.getGraphUuid(), internalGraphState.getTransactionId(), Math::max));
        return internalGraphTxIds.entrySet().stream().map(entry -> new InternalGraphState((UUID)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    private static List<ExternalGraphState> mergeExternalGraphStates(List<FabricBookmark> fabricBookmarks) {
        HashMap externalGraphStates = new HashMap();
        fabricBookmarks.stream().flatMap(fabricBookmark -> fabricBookmark.getExternalGraphStates().stream()).forEach(externalGraphState -> externalGraphStates.computeIfAbsent(externalGraphState.getGraphUuid(), key -> new ArrayList()).addAll(externalGraphState.getBookmarks()));
        return externalGraphStates.entrySet().stream().map(entry -> new ExternalGraphState((UUID)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FabricBookmark that = (FabricBookmark)((Object)o);
        return this.internalGraphStates.equals(that.internalGraphStates) && this.externalGraphStates.equals(that.externalGraphStates);
    }

    public int hashCode() {
        return Objects.hash(this.internalGraphStates, this.externalGraphStates);
    }

    public String toString() {
        return "FabricBookmark{internalGraphStates=" + this.internalGraphStates + ", externalGraphStates=" + this.externalGraphStates + "}";
    }

    public static class ExternalGraphState {
        private final UUID graphUuid;
        private final List<RemoteBookmark> bookmarks;

        public ExternalGraphState(UUID graphUuid, List<RemoteBookmark> bookmarks) {
            this.graphUuid = graphUuid;
            this.bookmarks = bookmarks;
        }

        public UUID getGraphUuid() {
            return this.graphUuid;
        }

        public List<RemoteBookmark> getBookmarks() {
            return this.bookmarks;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalGraphState that = (ExternalGraphState)o;
            return this.graphUuid.equals(that.graphUuid) && this.bookmarks.equals(that.bookmarks);
        }

        public int hashCode() {
            return Objects.hash(this.graphUuid, this.bookmarks);
        }

        public String toString() {
            return "ExternalGraphState{graphUuid=" + this.graphUuid + ", bookmarks=" + this.bookmarks + "}";
        }
    }

    public static class InternalGraphState {
        private final UUID graphUuid;
        private final long transactionId;

        public InternalGraphState(UUID graphUuid, long transactionId) {
            this.graphUuid = graphUuid;
            this.transactionId = transactionId;
        }

        public UUID getGraphUuid() {
            return this.graphUuid;
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternalGraphState that = (InternalGraphState)o;
            return this.transactionId == that.transactionId && this.graphUuid.equals(that.graphUuid);
        }

        public int hashCode() {
            return Objects.hash(this.graphUuid, this.transactionId);
        }

        public String toString() {
            return "InternalGraphState{graphUuid=" + this.graphUuid + ", transactionId=" + this.transactionId + "}";
        }
    }
}

