/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.stream.InputDataStreamImpl;
import org.neo4j.fabric.stream.QuerySubject;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Rx2SyncStream;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.StatementResults;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.values.virtual.MapValue;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FabricKernelTransaction {
    private final ExecutionEngine queryExecutionEngine;
    private final TransactionalContextFactory transactionalContextFactory;
    private final InternalTransaction internalTransaction;
    private final FabricConfig config;
    private final Set<TransactionalContext> openExecutionContexts = ConcurrentHashMap.newKeySet();
    private final FabricTransactionInfo transactionInfo;

    FabricKernelTransaction(ExecutionEngine queryExecutionEngine, TransactionalContextFactory transactionalContextFactory, InternalTransaction internalTransaction, FabricConfig config, FabricTransactionInfo transactionInfo) {
        this.queryExecutionEngine = queryExecutionEngine;
        this.transactionalContextFactory = transactionalContextFactory;
        this.internalTransaction = internalTransaction;
        this.config = config;
        this.transactionInfo = transactionInfo;
    }

    public StatementResult run(FullyParsedQuery query, MapValue params, Flux<Record> input, FabricStatementLifecycles.StatementLifecycle parentLifecycle, ExecutionOptions executionOptions) {
        TransactionalContext childExecutionContext = this.makeChildTransactionalContext(parentLifecycle);
        parentLifecycle.startExecution(true);
        QueryExecutionMonitor childQueryMonitor = parentLifecycle.getChildQueryMonitor();
        this.openExecutionContexts.add(childExecutionContext);
        StatementResults.SubscribableExecution execution = this.execute(query, params, childExecutionContext, this.convert(input), childQueryMonitor);
        QuerySubject.BasicQuerySubject subject = executionOptions.addSourceTag() ? new QuerySubject.TaggingQuerySubject(executionOptions.sourceId()) : new QuerySubject.BasicQuerySubject();
        StatementResult result = StatementResults.connectVia(execution, subject);
        return new ContextClosingResultInterceptor(result, childExecutionContext);
    }

    private StatementResults.SubscribableExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext executionContext, InputDataStream input, QueryExecutionMonitor queryMonitor) {
        return subscriber -> {
            try {
                return this.queryExecutionEngine.executeQuery(query, params, executionContext, true, input, queryMonitor, subscriber);
            }
            catch (QueryExecutionKernelException e) {
                Throwable cause = e.getCause() == null ? e : e.getCause();
                throw Exceptions.transform((Status)Status.Statement.ExecutionFailed, cause, executionContext.executingQuery().internalQueryId());
            }
        };
    }

    private TransactionalContext makeChildTransactionalContext(FabricStatementLifecycles.StatementLifecycle lifecycle) {
        ExecutingQuery parentQuery = lifecycle.getMonitoredQuery();
        QueryExecutionConfiguration queryExecutionConfiguration = this.transactionInfo.getQueryExecutionConfiguration();
        if (lifecycle.isParentChildMonitoringMode()) {
            String queryText = "Internal query for parent query id: " + parentQuery.id();
            MapValue params = MapValue.EMPTY;
            return this.transactionalContextFactory.newContext(this.internalTransaction, queryText, parentQuery, params, queryExecutionConfiguration);
        }
        return this.transactionalContextFactory.newContextForQuery(this.internalTransaction, parentQuery, queryExecutionConfiguration);
    }

    private InputDataStream convert(Flux<Record> input) {
        return new InputDataStreamImpl(new Rx2SyncStream(input, this.config.getDataStream().getBatchSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        InternalTransaction internalTransaction = this.internalTransaction;
        synchronized (internalTransaction) {
            if (this.internalTransaction.isOpen()) {
                this.closeContexts();
                this.internalTransaction.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        InternalTransaction internalTransaction = this.internalTransaction;
        synchronized (internalTransaction) {
            if (this.internalTransaction.isOpen()) {
                this.closeContexts();
                this.internalTransaction.rollback();
            }
        }
    }

    private void closeContexts() {
        this.openExecutionContexts.forEach(TransactionalContext::close);
    }

    public void terminate(Status reason) {
        this.terminateIfPossible(reason);
    }

    public void terminateIfPossible(Status reason) {
        if (this.internalTransaction.isOpen() && this.internalTransaction.terminationReason().isEmpty()) {
            this.internalTransaction.terminate(reason);
        }
    }

    @Deprecated
    public InternalTransaction getInternalTransaction() {
        return this.internalTransaction;
    }

    public Long transactionId() {
        return this.internalTransaction.kernelTransaction().getTransactionId();
    }

    private class ContextClosingResultInterceptor
    implements StatementResult {
        private final StatementResult wrappedResult;
        private final TransactionalContext executionContext;

        ContextClosingResultInterceptor(StatementResult wrappedResult, TransactionalContext executionContext) {
            this.wrappedResult = wrappedResult;
            this.executionContext = executionContext;
        }

        @Override
        public List<String> columns() {
            return this.wrappedResult.columns();
        }

        @Override
        public Flux<Record> records() {
            return this.wrappedResult.records().doOnComplete(() -> {
                FabricKernelTransaction.this.openExecutionContexts.remove(this.executionContext);
                this.executionContext.close();
            });
        }

        @Override
        public Mono<Summary> summary() {
            return this.wrappedResult.summary();
        }

        @Override
        public Mono<QueryExecutionType> executionType() {
            return this.wrappedResult.executionType();
        }
    }
}

