/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.cypher.internal.frontend.phases.InternalUsageStats;
import org.neo4j.cypher.internal.frontend.phases.SchemaInferenceUsageMetricKey;
import org.neo4j.cypher.internal.frontend.phases.SyntaxUsageMetricKey;

public final class InternalUsageStatsImpl
implements InternalUsageStats {
    private final ConcurrentHashMap<SyntaxUsageMetricKey, LongAdder> syntaxUsageCounts = new ConcurrentHashMap();
    private final ConcurrentHashMap<SchemaInferenceUsageMetricKey, LongAdder> labelInferenceUsageCounts = new ConcurrentHashMap();

    @Override
    public void incrementSyntaxUsageCount(SyntaxUsageMetricKey key) {
        this.syntaxUsageCounts.computeIfAbsent(key, k -> new LongAdder()).increment();
    }

    @Override
    public long getSyntaxUsageCount(SyntaxUsageMetricKey key) {
        LongAdder count = this.syntaxUsageCounts.get((Object)key);
        return count == null ? 0L : count.longValue();
    }

    @Override
    public void incrementSchemaInferenceUsageCount(SchemaInferenceUsageMetricKey key) {
        this.labelInferenceUsageCounts.computeIfAbsent(key, k -> new LongAdder()).increment();
    }

    @Override
    public long getSchemaInferenceUsageCount(SchemaInferenceUsageMetricKey key) {
        LongAdder count = this.labelInferenceUsageCounts.get((Object)key);
        return count == null ? 0L : count.longValue();
    }
}

