/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.expressions.AutoExtractedParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Literal;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.SensitiveAutoParameter;
import org.neo4j.cypher.internal.expressions.SensitiveLiteral;
import org.neo4j.cypher.internal.expressions.SensitiveParameter;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Foldable$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.cypher.internal.util.StepSequencer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ObfuscationMetadataCollection$
implements Phase<BaseContext, BaseState, BaseState>,
Product,
Serializable {
    public static final ObfuscationMetadataCollection$ MODULE$ = new ObfuscationMetadataCollection$();

    static {
        Transformer.$init$(MODULE$);
        Phase.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public Object transform(Object from, BaseContext context) {
        return Phase.transform$(this, from, context);
    }

    @Override
    public String name() {
        return Phase.name$(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$(this, other);
    }

    @Override
    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Transformer.invalidatedConditions$(this);
    }

    @Override
    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions, CancellationChecker cancellationChecker) {
        return Transformer.checkConditions$(this, state, conditions, cancellationChecker);
    }

    @Override
    public final void printDebugInfo(Object fromState, Object toState) {
        Transformer.printDebugInfo$(this, fromState, toState);
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.METADATA_COLLECTION;
    }

    @Override
    public Set<StepSequencer.Condition> postConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    @Override
    public BaseState process(BaseState from, BaseContext context) {
        Set extractedParamNames = (Set)from.maybeExtractedParams().map((Function1 & Serializable)x$1 -> (Set)x$1.keySet().map((Function1 & Serializable)x$2 -> x$2.name())).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        Seq parameters = from.statement().folder().findAllByClass(ClassTag$.MODULE$.apply(Parameter.class));
        Vector<LiteralOffset> offsets = this.collectSensitiveLiteralOffsets(from.statement(), (Map<AutoExtractedParameter, Expression>)((Map)from.maybeExtractedParams().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())));
        Set<String> sensitiveParams = this.collectSensitiveParameterNames((Seq<Parameter>)parameters, (Set<String>)extractedParamNames);
        return from.withObfuscationMetadata(new ObfuscationMetadata(offsets, sensitiveParams));
    }

    private Vector<LiteralOffset> collectSensitiveLiteralOffsets(Statement statement, Map<AutoExtractedParameter, Expression> extractedParameters) {
        Serializable partial = new Serializable(extractedParameters){
            private static final long serialVersionUID = 0L;
            private final Map extractedParameters$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SensitiveLiteral) {
                    SensitiveLiteral sensitiveLiteral = (SensitiveLiteral)A1;
                    return (B1)(Function1 & Serializable)acc -> new Foldable.SkipChildren(acc.$colon$plus((Object)new LiteralOffset(sensitiveLiteral.position().offset(), sensitiveLiteral.position().line(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)sensitiveLiteral.literalLength())))));
                }
                if (A1 instanceof AutoExtractedParameter && A1 instanceof SensitiveAutoParameter) {
                    AutoExtractedParameter autoExtractedParameter = (AutoExtractedParameter)A1;
                    return (B1)(Function1 & Serializable)acc -> {
                        Option option = $this.extractedParameters$1.get((Object)autoExtractedParameter);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Expression originalExp = (Expression)some.value();
                            Seq literalOffsets = (Seq)((IterableOps)originalExp.folder().findAllByClass(ClassTag$.MODULE$.apply(Literal.class)).map((Function1 & Serializable)x$3 -> x$3.asSensitiveLiteral())).map((Function1 & Serializable)l -> new LiteralOffset(((SensitiveLiteral)l).position().offset(), ((SensitiveLiteral)l).position().line(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((SensitiveLiteral)l).literalLength()))));
                            return new Foldable.SkipChildren(acc.$plus$plus((IterableOnce)literalOffsets));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return new Foldable.SkipChildren(acc.$colon$plus((Object)new LiteralOffset(autoExtractedParameter.position().offset(), autoExtractedParameter.position().line(), (Option)None$.MODULE$)));
                        }
                        throw new MatchError((Object)option);
                    };
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof SensitiveLiteral) {
                    return true;
                }
                return object instanceof AutoExtractedParameter && object instanceof SensitiveAutoParameter;
            }
            {
                this.extractedParameters$1 = extractedParameters$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.expressions.SensitiveLiteral scala.collection.immutable.Vector ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.frontend.phases.ObfuscationMetadataCollection$$anonfun$1 org.neo4j.cypher.internal.expressions.AutoExtractedParameter scala.collection.immutable.Vector ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.expressions.Literal ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.expressions.Literal )}, serializedLambda);
            }
        };
        Vector fromStatement = (Vector)statement.folder().treeFold((Object)package$.MODULE$.Vector().empty(), (PartialFunction)partial);
        Vector fromStatementAndExtracted = (Vector)Foldable$.MODULE$.FoldableAny(extractedParameters).folder().treeFold((Object)fromStatement, (PartialFunction)partial);
        return (Vector)((SeqOps)fromStatementAndExtracted.distinct()).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.start(0)), (Ordering)Ordering.Int$.MODULE$);
    }

    private Set<String> collectSensitiveParameterNames(Seq<Parameter> queryParams, Set<String> extractedParamNames) {
        return (Set)((IterableOnceOps)Foldable$.MODULE$.FoldableAny(queryParams).folder().findAllByClass(ClassTag$.MODULE$.apply(SensitiveParameter.class)).map((Function1 & Serializable)x$5 -> x$5.name())).toSet().$minus$minus(extractedParamNames);
    }

    public String productPrefix() {
        return "ObfuscationMetadataCollection";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ObfuscationMetadataCollection$;
    }

    public int hashCode() {
        return 1152578288;
    }

    public String toString() {
        return "ObfuscationMetadataCollection";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ObfuscationMetadataCollection$.class);
    }

    private ObfuscationMetadataCollection$() {
    }
}

