/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.ProcedureResultItem;
import org.neo4j.cypher.internal.ast.ProjectingUnionAll;
import org.neo4j.cypher.internal.ast.ProjectingUnionDistinct;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnionAll;
import org.neo4j.cypher.internal.ast.UnionDistinct;
import org.neo4j.cypher.internal.ast.semantics.Scope;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable$;
import org.neo4j.cypher.internal.ast.semantics.SymbolUse;
import org.neo4j.cypher.internal.ast.semantics.SymbolUse$;
import org.neo4j.cypher.internal.expressions.ExpressionWithOuterScope;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.ProcedureOutput;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Condition;
import org.neo4j.cypher.internal.frontend.phases.Namespacer$;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.StatementCondition;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.rewriting.conditions.containsNoNodesOfType;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Ref;
import org.neo4j.cypher.internal.util.Ref$;
import org.neo4j.cypher.internal.util.Rewritable;
import org.neo4j.cypher.internal.util.Rewritable$;
import org.neo4j.cypher.internal.util.Rewriter$;
import org.neo4j.cypher.internal.util.bottomUp$;
import org.neo4j.cypher.internal.util.inSequence$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class Namespacer$
implements Phase<BaseContext, BaseState, BaseState> {
    public static Namespacer$ MODULE$;

    static {
        new Namespacer$();
    }

    @Override
    public Object transform(Object from, BaseContext context) {
        return Phase.transform$(this, from, context);
    }

    @Override
    public String name() {
        return Phase.name$(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$(this, other);
    }

    @Override
    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.adds$(this, condition);
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.AST_REWRITE;
    }

    @Override
    public String description() {
        return "rename variables so they are all unique";
    }

    @Override
    public BaseState process(BaseState from, BaseContext ignored) {
        BaseState baseState;
        Statement withProjectedUnions = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)from.statement()), this.projectUnions());
        SemanticTable table = SemanticTable$.MODULE$.apply(from.semantics().typeTable(), from.semantics().recordedScopes().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> SemanticState.ScopeLocation$.MODULE$.scope$extension(((SemanticState.ScopeLocation)x$1).location())));
        Set<String> ambiguousNames = this.shadowedNames(from.semantics().scopeTree());
        Map variableDefinitions = from.semantics().scopeTree().allVariableDefinitions();
        Map<Ref<Variable>, Variable> renamings = this.variableRenamings(withProjectedUnions, (Map<SymbolUse, SymbolUse>)variableDefinitions, ambiguousNames);
        if (renamings.isEmpty()) {
            baseState = from.withStatement(withProjectedUnions).withSemanticTable(table);
        } else {
            Function1<Object, Object> rewriter = this.renamingRewriter(renamings);
            Statement newStatement = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)withProjectedUnions), rewriter);
            SemanticTable newSemanticTable = table.replaceExpressions(rewriter);
            baseState = from.withStatement(newStatement).withSemanticTable(newSemanticTable);
        }
        return baseState;
    }

    @Override
    public Set<Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Condition[]{new StatementCondition((Function1<Object, Seq<String>>)new containsNoNodesOfType(ClassTag$.MODULE$.apply(UnionAll.class))), new StatementCondition((Function1<Object, Seq<String>>)new containsNoNodesOfType(ClassTag$.MODULE$.apply(UnionDistinct.class)))}));
    }

    private Set<String> shadowedNames(Scope scopeTree) {
        Map definitions = scopeTree.allSymbolDefinitions();
        return ((TraversableOnce)definitions.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Set<SymbolUse>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    Set symbolDefinitions = (Set)A1._2();
                    if (symbolDefinitions.size() > 1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Set<SymbolUse>> x1) {
                Set symbolDefinitions;
                Tuple2<String, Set<SymbolUse>> tuple2 = x1;
                boolean bl = tuple2 != null && (symbolDefinitions = (Set)tuple2._2()).size() > 1;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Map<Ref<Variable>, Variable> variableRenamings(Statement statement, Map<SymbolUse, SymbolUse> variableDefinitions, Set<String> ambiguousNames) {
        return (Map)statement.folder().treeFold((Object)Predef$.MODULE$.Map().empty(), (PartialFunction)new scala.Serializable(ambiguousNames, variableDefinitions){
            public static final long serialVersionUID = 0L;
            private final Set ambiguousNames$1;
            private final Map variableDefinitions$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                Variable variable;
                A1 A1 = x1;
                if (A1 instanceof Variable && this.ambiguousNames$1.apply((Object)(variable = (Variable)A1).name())) {
                    Tuple2<Ref<Variable>, Variable> renaming = Namespacer$.MODULE$.org$neo4j$cypher$internal$frontend$phases$Namespacer$$createVariableRenaming((Map<SymbolUse, SymbolUse>)this.variableDefinitions$1, variable);
                    intersect = (Function1 & Serializable & scala.Serializable)acc -> new Foldable.TraverseChildren((Object)acc.$plus(renaming));
                } else if (A1 instanceof ExpressionWithOuterScope) {
                    ExpressionWithOuterScope expressionWithOuterScope = (ExpressionWithOuterScope)A1;
                    Set renamings = (Set)((TraversableOnce)expressionWithOuterScope.outerScope().filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)anonfun.variableRenamings.1.$anonfun$applyOrElse$2(this, v)))).foldLeft((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(innerAcc, v) -> (Set)innerAcc.$plus(Namespacer$.MODULE$.org$neo4j$cypher$internal$frontend$phases$Namespacer$$createVariableRenaming((Map<SymbolUse, SymbolUse>)$this.variableDefinitions$1, (Variable)v)));
                    intersect = (Function1 & Serializable & scala.Serializable)acc -> new Foldable.TraverseChildren((Object)acc.$plus$plus((GenTraversableOnce)renamings));
                } else {
                    intersect = function1.apply(x1);
                }
                return (B1)intersect;
            }

            public final boolean isDefinedAt(Object x1) {
                Variable variable;
                Object object = x1;
                boolean bl = object instanceof Variable && this.ambiguousNames$1.apply((Object)(variable = (Variable)object).name()) ? true : object instanceof ExpressionWithOuterScope;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2(anonfun.variableRenamings.1 $this, Variable v) {
                return $this.ambiguousNames$1.apply((Object)v.name());
            }
            {
                this.ambiguousNames$1 = ambiguousNames$1;
                this.variableDefinitions$1 = variableDefinitions$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.Tuple2 scala.collection.immutable.Map ), $anonfun$applyOrElse$2$adapted(org.neo4j.cypher.internal.frontend.phases.Namespacer$$anonfun$variableRenamings$1 org.neo4j.cypher.internal.expressions.Variable ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.frontend.phases.Namespacer$$anonfun$variableRenamings$1 scala.collection.immutable.Set org.neo4j.cypher.internal.expressions.Variable ), $anonfun$applyOrElse$4(scala.collection.immutable.Set scala.collection.immutable.Map )}, serializedLambda);
            }
        });
    }

    public Tuple2<Ref<Variable>, Variable> org$neo4j$cypher$internal$frontend$phases$Namespacer$$createVariableRenaming(Map<SymbolUse, SymbolUse> variableDefinitions, Variable v) {
        SymbolUse symbolDefinition = (SymbolUse)variableDefinitions.apply((Object)SymbolUse$.MODULE$.apply((LogicalVariable)v));
        Variable newVariable = v.renameId(new StringBuilder(2).append("  ").append(symbolDefinition.nameWithPosition()).toString());
        Tuple2 renaming = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Ref$.MODULE$.apply((Object)v)), (Object)newVariable);
        return renaming;
    }

    private Function1<Object, Object> projectUnions() {
        return bottomUp$.MODULE$.apply(Rewriter$.MODULE$.lift((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof UnionAll) {
                    UnionAll unionAll = (UnionAll)A1;
                    object = new ProjectingUnionAll(unionAll.part(), unionAll.query(), unionAll.unionMappings(), unionAll.position());
                } else if (A1 instanceof UnionDistinct) {
                    UnionDistinct unionDistinct = (UnionDistinct)A1;
                    object = new ProjectingUnionDistinct(unionDistinct.part(), unionDistinct.query(), unionDistinct.unionMappings(), unionDistinct.position());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof UnionAll ? true : object instanceof UnionDistinct;
                return bl;
            }
        }), bottomUp$.MODULE$.apply$default$2(), bottomUp$.MODULE$.apply$default$3());
    }

    private Function1<Object, Object> renamingRewriter(Map<Ref<Variable>, Variable> renamings) {
        return inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{bottomUp$.MODULE$.apply(Rewriter$.MODULE$.lift((PartialFunction)new scala.Serializable(renamings){
            public static final long serialVersionUID = 0L;
            private final Map renamings$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ProcedureResultItem) {
                    Variable variable;
                    ProcedureResultItem procedureResultItem = (ProcedureResultItem)A1;
                    Option option = procedureResultItem.output();
                    LogicalVariable v = procedureResultItem.variable();
                    if (None$.MODULE$.equals(option) && v instanceof Variable && this.renamings$2.contains((Object)Ref$.MODULE$.apply((Object)(variable = (Variable)v)))) {
                        object = procedureResultItem.copy((Option)new Some((Object)new ProcedureOutput(variable.name(), variable.position())), procedureResultItem.copy$default$2(), procedureResultItem.position());
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (!(object instanceof ProcedureResultItem)) return false;
                ProcedureResultItem procedureResultItem = (ProcedureResultItem)object;
                Option option = procedureResultItem.output();
                LogicalVariable v = procedureResultItem.variable();
                if (!None$.MODULE$.equals(option)) return false;
                if (!(v instanceof Variable)) return false;
                Variable variable = (Variable)v;
                if (!this.renamings$2.contains((Object)Ref$.MODULE$.apply((Object)variable))) return false;
                return true;
            }
            {
                this.renamings$2 = renamings$2;
            }
        }), bottomUp$.MODULE$.apply$default$2(), bottomUp$.MODULE$.apply$default$3()), bottomUp$.MODULE$.apply(Rewriter$.MODULE$.lift((PartialFunction)new scala.Serializable(renamings){
            public static final long serialVersionUID = 0L;
            private final Map renamings$2;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Variable) {
                    Variable variable;
                    Variable variable2 = (Variable)A1;
                    Option option = this.renamings$2.get((Object)Ref$.MODULE$.apply((Object)variable2));
                    if (option instanceof Some) {
                        Variable newVariable;
                        Some some = (Some)option;
                        variable = newVariable = (Variable)some.value();
                    } else if (None$.MODULE$.equals(option)) {
                        variable = variable2;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = variable;
                } else if (A1 instanceof ExpressionWithOuterScope) {
                    ExpressionWithOuterScope expressionWithOuterScope = (ExpressionWithOuterScope)A1;
                    Set newOuterScope = (Set)expressionWithOuterScope.outerScope().map((Function1 & Serializable & scala.Serializable)v -> {
                        Variable variable;
                        Option option = $this.renamings$2.get((Object)Ref$.MODULE$.apply(v));
                        if (option instanceof Some) {
                            Variable newVariable;
                            Some some = (Some)option;
                            variable = newVariable = (Variable)some.value();
                        } else if (None$.MODULE$.equals(option)) {
                            variable = v;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return variable;
                    }, Set$.MODULE$.canBuildFrom());
                    object = expressionWithOuterScope.withOuterScope(newOuterScope);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof Variable ? true : object instanceof ExpressionWithOuterScope;
                return bl;
            }
            {
                this.renamings$2 = renamings$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.neo4j.cypher.internal.frontend.phases.Namespacer$$anonfun$renamingRewriter$2 org.neo4j.cypher.internal.expressions.Variable )}, serializedLambda);
            }
        }), bottomUp$.MODULE$.apply$default$2(), bottomUp$.MODULE$.apply$default$3())}));
    }

    private Namespacer$() {
        MODULE$ = this;
        Transformer.$init$(this);
        Phase.$init$(this);
    }
}

