/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.SensitiveParameter;
import org.neo4j.cypher.internal.expressions.SensitiveString;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Condition;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Foldable$;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ObfuscationMetadataCollection$
implements Phase<BaseContext, BaseState, BaseState> {
    public static ObfuscationMetadataCollection$ MODULE$;

    static {
        new ObfuscationMetadataCollection$();
    }

    @Override
    public Object transform(Object from, BaseContext context) {
        return Phase.transform$(this, from, context);
    }

    @Override
    public String name() {
        return Phase.name$(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$(this, other);
    }

    @Override
    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.adds$(this, condition);
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.METADATA_COLLECTION;
    }

    @Override
    public String description() {
        return "collect sensitive literals and parameters";
    }

    @Override
    public Set<Condition> postConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    @Override
    public BaseState process(BaseState from, BaseContext context) {
        Set extractedParamNames = (Set)from.maybeExtractedParams().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.keys().toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        int preParserOffset = BoxesRunTime.unboxToInt((Object)from.startPosition().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.offset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Seq parameters = Foldable.FoldableAny$.MODULE$.findByAllClass$extension(Foldable$.MODULE$.FoldableAny((Object)from.statement()), ClassTag$.MODULE$.apply(Parameter.class));
        Vector<Object> offsets = this.collectSensitiveLiteralOffsets(from.statement(), (Set<String>)extractedParamNames, preParserOffset);
        Set<String> sensitiveParams = this.collectSensitiveParameterNames((Seq<Parameter>)parameters, (Set<String>)extractedParamNames);
        return from.withObfuscationMetadata(new ObfuscationMetadata(offsets, sensitiveParams));
    }

    private Vector<Object> collectSensitiveLiteralOffsets(Statement statement, Set<String> extractedParamNames, int preParserOffset) {
        return (Vector)((TraversableLike)((SeqLike)((SeqLike)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)statement), (Object)package$.MODULE$.Vector().empty(), (PartialFunction)new scala.Serializable(extractedParamNames){
            public static final long serialVersionUID = 0L;
            private final Set extractedParamNames$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                A1 A1 = x1;
                if (A1 instanceof SensitiveString) {
                    SensitiveString sensitiveString = (SensitiveString)A1;
                    intersect = (Function1 & Serializable & scala.Serializable)acc -> new Foldable.SkipChildren(acc.$colon$plus((Object)BoxesRunTime.boxToInteger((int)sensitiveString.position().offset()), Vector$.MODULE$.canBuildFrom()));
                } else {
                    SensitiveParameter sensitiveParameter;
                    intersect = A1 instanceof SensitiveParameter && this.extractedParamNames$1.contains((Object)(sensitiveParameter = (SensitiveParameter)A1).name()) ? (Function1 & Serializable & scala.Serializable)acc -> new Foldable.SkipChildren(acc.$colon$plus((Object)BoxesRunTime.boxToInteger((int)sensitiveParameter.position().offset()), Vector$.MODULE$.canBuildFrom())) : function1.apply(x1);
                }
                return (B1)intersect;
            }

            public final boolean isDefinedAt(Object x1) {
                SensitiveParameter sensitiveParameter;
                Object object = x1;
                boolean bl = object instanceof SensitiveString ? true : object instanceof SensitiveParameter && this.extractedParamNames$1.contains((Object)(sensitiveParameter = (SensitiveParameter)object).name());
                return bl;
            }
            {
                this.extractedParamNames$1 = extractedParamNames$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.expressions.SensitiveString scala.collection.immutable.Vector ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.SensitiveParameter scala.collection.immutable.Vector )}, serializedLambda);
            }
        })).distinct()).sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$3 -> x$3 + preParserOffset, Vector$.MODULE$.canBuildFrom());
    }

    private Set<String> collectSensitiveParameterNames(Seq<Parameter> queryParams, Set<String> extractedParamNames) {
        return (Set)((TraversableOnce)Foldable.FoldableAny$.MODULE$.findByAllClass$extension(Foldable$.MODULE$.FoldableAny(queryParams), ClassTag$.MODULE$.apply(SensitiveParameter.class)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus(extractedParamNames);
    }

    private ObfuscationMetadataCollection$() {
        MODULE$ = this;
        Transformer.$init$(this);
        Phase.$init$(this);
    }
}

