/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.PatternExpression;
import org.neo4j.cypher.internal.expressions.functions.Exists$;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.ExpectedBooleanTypeCheck;
import org.neo4j.cypher.internal.util.Foldable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LambdaDeserialize;

public final class PatternExpressionInNonExistenceCheck$
implements ExpectedBooleanTypeCheck {
    public static final PatternExpressionInNonExistenceCheck$ MODULE$ = new PatternExpressionInNonExistenceCheck$();
    private static final String errorMessage;

    static {
        ExpectedBooleanTypeCheck.$init$(MODULE$);
        errorMessage = "A pattern expression should only be used in order to test the existence of a pattern. It should therefore only be used in contexts that evaluate to a boolean, e.g. inside the function exists() or in a WHERE-clause. No other uses are allowed, instead they should be replaced by a pattern comprehension.";
    }

    @Override
    public boolean isExpectedTypeBoolean(SemanticTable semanticTable, Expression e) {
        return ExpectedBooleanTypeCheck.isExpectedTypeBoolean$(this, semanticTable, e);
    }

    public Function2<BaseState, BaseContext, Seq<SemanticError>> patternExpressionInNonExistenceCheck() {
        return (Function2 & Serializable)(baseState, x$3) -> (Seq)baseState.statement().folder().treeFold((Object)package$.MODULE$.Seq().empty(), (PartialFunction)new Serializable((BaseState)baseState){
            private static final long serialVersionUID = 0L;
            private final BaseState baseState$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable intersect;
                Expression expression;
                Option option;
                A1 A1 = x1;
                if (A1 instanceof Expression && !(option = Exists$.MODULE$.unapply(expression = (Expression)A1)).isEmpty()) {
                    intersect = (Function1 & Serializable)errors -> new Foldable.SkipChildren(errors);
                    return (B1)intersect;
                }
                if (A1 instanceof PatternExpression) {
                    PatternExpression patternExpression = (PatternExpression)A1;
                    if (!PatternExpressionInNonExistenceCheck$.MODULE$.isExpectedTypeBoolean(this.baseState$1.semanticTable(), (Expression)patternExpression)) {
                        intersect = (Function1 & Serializable)errors -> new Foldable.SkipChildren(errors.$colon$plus((Object)new SemanticError(PatternExpressionInNonExistenceCheck$.MODULE$.errorMessage(), patternExpression.position())));
                        return (B1)intersect;
                    }
                }
                intersect = function1.apply(x1);
                return (B1)intersect;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                Expression expression;
                Option option;
                Object object = x1;
                if (object instanceof Expression && !(option = Exists$.MODULE$.unapply(expression = (Expression)object)).isEmpty()) {
                    return true;
                }
                if (!(object instanceof PatternExpression)) return false;
                PatternExpression patternExpression = (PatternExpression)object;
                if (PatternExpressionInNonExistenceCheck$.MODULE$.isExpectedTypeBoolean(this.baseState$1.semanticTable(), (Expression)patternExpression)) return false;
                return true;
            }
            {
                this.baseState$1 = baseState$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.Seq ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.PatternExpression scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
    }

    public String errorMessage() {
        return errorMessage;
    }

    private PatternExpressionInNonExistenceCheck$() {
    }
}

