/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHitCountCollector;
import org.eclipse.collections.impl.block.factory.primitive.LongPredicates;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexAnalyzerLoader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexTransactionState;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.fulltext.PreparedSearch;
import org.neo4j.kernel.api.impl.fulltext.StatsCollector;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.ScoredEntityIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.partition.Neo4jIndexSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneScoredEntityIndexProgressor;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public class FulltextIndexReader
implements ValueIndexReader {
    private static final LongPredicate ALWAYS_FALSE = LongPredicates.alwaysFalse();
    private final List<SearcherReference> searchers;
    private final TokenHolder propertyKeyTokenHolder;
    private final IndexDescriptor index;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private final FulltextIndexTransactionState transactionState;
    private final IndexUsageTracking usageTracker;
    private final Log log;

    FulltextIndexReader(List<SearcherReference> searchers, TokenHolder propertyKeyTokenHolder, IndexDescriptor descriptor, Config config, Analyzer analyzer, String[] propertyNames, IndexUsageTracking usageTracker, LogProvider logProvider) {
        this.searchers = searchers;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.index = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.usageTracker = usageTracker;
        this.transactionState = new FulltextIndexTransactionState(descriptor, config, analyzer, propertyNames);
        this.log = logProvider.getLog(this.getClass());
    }

    public IndexSampler createSampler() {
        return IndexSampler.EMPTY;
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, CursorContext cursorContext, IndexQueryConstraints constraints, PropertyIndexQuery ... queries) throws IndexNotApplicableKernelException {
        PropertyIndexQuery predicate = this.validateQuery(queries);
        Query query = this.toLuceneQuery(predicate);
        context.monitor().queried(this.index);
        this.usageTracker.queried();
        ValuesIterator iterator = this.searchLucene(query, constraints, context, context.cursorContext(), context.memoryTracker());
        LuceneScoredEntityIndexProgressor progressor = new LuceneScoredEntityIndexProgressor(iterator, client, constraints);
        client.initializeQuery(this.index, (IndexProgressor)progressor, true, false, constraints, queries);
    }

    private PropertyIndexQuery validateQuery(PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            throw this.invalidCompositeQuery(msg -> IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)this.index.getName(), (String)msg), predicates);
        }
        PropertyIndexQuery predicate = predicates[0];
        if (!this.index.getCapability().isQuerySupported(predicate.type(), predicate.valueCategory())) {
            throw this.invalidQuery(msg -> IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)this.index.getName(), (String)msg), predicate);
        }
        return predicate;
    }

    private <E extends Exception> E invalidCompositeQuery(Function<String, E> constructor, PropertyIndexQuery ... predicates) {
        IndexType indexType = this.index.getIndexType();
        return (E)((Exception)constructor.apply("Tried to query a %s index with a composite query. Composite queries are not supported by a %s index. Query was: %s ".formatted(indexType, indexType, Arrays.toString(predicates))));
    }

    private Query toLuceneQuery(PropertyIndexQuery predicate) {
        MatchAllDocsQuery matchAllDocsQuery;
        switch (predicate.type()) {
            case ALL_ENTRIES: {
                MatchAllDocsQuery matchAllDocsQuery2;
                matchAllDocsQuery = matchAllDocsQuery2 = new MatchAllDocsQuery();
                break;
            }
            case FULLTEXT_SEARCH: {
                PropertyIndexQuery.FulltextSearchPredicate fulltextSearchPredicate = (PropertyIndexQuery.FulltextSearchPredicate)predicate;
                try {
                    Query query = this.parseFulltextQuery(fulltextSearchPredicate.query(), fulltextSearchPredicate.queryAnalyzer());
                    BooleanQuery booleanQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.SHOULD).build();
                    matchAllDocsQuery = booleanQuery;
                    break;
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Could not parse the given fulltext search query: '%s'.".formatted(fulltextSearchPredicate.query()), parseException);
                }
            }
            default: {
                throw this.invalidQuery(IllegalArgumentException::new, predicate);
            }
        }
        return matchAllDocsQuery;
    }

    private <E extends Exception> E invalidQuery(Function<String, E> constructor, PropertyIndexQuery query) {
        return (E)((Exception)constructor.apply("A fulltext schema index cannot answer %s queries on %s values.".formatted(query.type(), query.valueCategory())));
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        long count = 0L;
        for (SearcherReference searcher : this.searchers) {
            try {
                String[] propertyKeys = new String[propertyKeyIds.length];
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    propertyKeys[i] = this.getPropertyKeyName(propertyKeyIds[i]);
                }
                Query query = LuceneFulltextDocumentStructure.newCountEntityEntriesQuery(entityId, propertyKeys, propertyValues);
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.getIndexSearcher().search(query, (Collector)collector);
                count += (long)collector.getTotalHits();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return count;
    }

    public void close() {
        ArrayList<Object> resources = new ArrayList<Object>(this.searchers.size() + 1);
        resources.addAll(this.searchers);
        resources.add(this.transactionState);
        IOUtils.close(IndexReaderCloseException::new, resources);
    }

    private Query parseFulltextQuery(String query, String queryAnalyzer) throws ParseException {
        Analyzer actualQueryAnalyzer = queryAnalyzer != null ? FulltextIndexAnalyzerLoader.INSTANCE.createAnalyzerFromString(queryAnalyzer) : this.analyzer;
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(this.propertyNames, actualQueryAnalyzer);
        multiFieldQueryParser.setAllowLeadingWildcard(true);
        return multiFieldQueryParser.parse(query);
    }

    private ValuesIterator searchLucene(Query query, IndexQueryConstraints constraints, QueryContext context, CursorContext cursorContext, MemoryTracker memoryTracker) {
        try {
            query = this.searchers.get(0).getIndexSearcher().rewrite(query);
            boolean includeTransactionState = context.getTransactionStateOrNull() != null && !FulltextIndexSettings.isEventuallyConsistent(this.index);
            LongPredicate filter = includeTransactionState ? this.transactionState.isModifiedInTransactionPredicate() : ALWAYS_FALSE;
            ArrayList<PreparedSearch> searches = new ArrayList<PreparedSearch>(this.searchers.size() + 1);
            for (SearcherReference searcher : this.searchers) {
                Neo4jIndexSearcher indexSearcher = searcher.getIndexSearcher();
                searches.add(new PreparedSearch(indexSearcher, filter));
            }
            if (includeTransactionState) {
                SearcherReference reference = this.transactionState.maybeUpdate(context, cursorContext, memoryTracker);
                searches.add(new PreparedSearch(reference.getIndexSearcher(), ALWAYS_FALSE));
            }
            StatsCollector statsCollector = new StatsCollector(searches);
            ArrayList<ValuesIterator> results = new ArrayList<ValuesIterator>(searches.size());
            for (PreparedSearch search : searches) {
                results.add(search.search(query, constraints, statsCollector));
            }
            return ScoredEntityIterator.mergeIterators(results);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyKeyName(int propertyKey) throws TokenNotFoundException {
        return this.propertyKeyTokenHolder.getTokenById(propertyKey).name();
    }
}

