/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.apache.lucene.analysis.Analyzer;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.NullIndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltextDatabaseIndex;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigModes;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.token.api.TokenHolder;

public class FulltextIndexBuilder
extends AbstractLuceneIndexBuilder<FulltextIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final TokenHolder propertyKeyTokenHolder;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private boolean populating;
    private IndexUpdateSink indexUpdateSink = NullIndexUpdateSink.INSTANCE;
    private final Config config;

    private FulltextIndexBuilder(IndexDescriptor descriptor, Config config, DatabaseReadOnlyChecker readOnlyChecker, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames, LogProvider logProvider) {
        super(readOnlyChecker, logProvider);
        this.config = config;
        this.descriptor = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    public static FulltextIndexBuilder create(IndexDescriptor descriptor, Config config, DatabaseReadOnlyChecker readOnlyChecker, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames, LogProvider logProvider) {
        return new FulltextIndexBuilder(descriptor, config, readOnlyChecker, propertyKeyTokenHolder, analyzer, propertyNames, logProvider);
    }

    FulltextIndexBuilder withPopulatingMode(boolean isPopulating) {
        this.populating = isPopulating;
        return this;
    }

    FulltextIndexBuilder withIndexUpdateSink(IndexUpdateSink indexUpdateSink) {
        this.indexUpdateSink = indexUpdateSink;
        return this;
    }

    public DatabaseIndex<FulltextIndexReader> build() {
        IndexWriterConfigBuilder writerConfigBuilder = this.populating ? new IndexWriterConfigBuilder(IndexWriterConfigModes.FulltextModes.POPULATION, this.config).withAnalyzer(this.analyzer) : new IndexWriterConfigBuilder(IndexWriterConfigModes.FulltextModes.STANDARD, this.config).withAnalyzer(this.analyzer);
        WritableIndexPartitionFactory partitionFactory = new WritableIndexPartitionFactory(() -> ((IndexWriterConfigBuilder)writerConfigBuilder).build());
        FulltextIndex fulltextIndex = new FulltextIndex(this.storageBuilder.build(), (IndexPartitionFactory)partitionFactory, this.descriptor, this.propertyKeyTokenHolder, this.config, this.analyzer, this.propertyNames, this.logProvider);
        return new WritableFulltextDatabaseIndex(this.indexUpdateSink, fulltextIndex, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

