/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.Semaphore;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.util.concurrent.BinaryLatch;

public class IndexUpdateSink {
    private final JobScheduler scheduler;
    private final Semaphore updateQueueLimit;

    IndexUpdateSink(JobScheduler scheduler, int eventuallyConsistentUpdateQueueLimit) {
        this.scheduler = scheduler;
        this.updateQueueLimit = new Semaphore(eventuallyConsistentUpdateQueueLimit);
    }

    public void enqueueUpdate(DatabaseIndex<? extends IndexReader> index, IndexUpdater indexUpdater, IndexEntryUpdate<?> update) {
        this.updateQueueLimit.acquireUninterruptibly();
        Runnable eventualUpdate = () -> {
            try {
                indexUpdater.process(update);
            }
            catch (IndexEntryConflictException e) {
                IndexUpdateSink.markAsFailed(index, e);
            }
            finally {
                this.updateQueueLimit.release();
            }
        };
        try {
            this.scheduler.schedule(Group.INDEX_UPDATING, eventualUpdate);
        }
        catch (Exception e) {
            this.updateQueueLimit.release();
            throw e;
        }
    }

    private static void markAsFailed(DatabaseIndex<? extends IndexReader> index, IndexEntryConflictException conflict) {
        try {
            index.markAsFailed(conflict.getMessage());
        }
        catch (IOException ioe) {
            ioe.addSuppressed(conflict);
            throw new UncheckedIOException(ioe);
        }
    }

    public void closeUpdater(DatabaseIndex<? extends IndexReader> index, IndexUpdater indexUpdater) {
        this.scheduler.schedule(Group.INDEX_UPDATING, () -> {
            try {
                indexUpdater.close();
            }
            catch (IndexEntryConflictException e) {
                IndexUpdateSink.markAsFailed(index, e);
            }
        });
    }

    public void awaitUpdateApplication() {
        BinaryLatch updateLatch = new BinaryLatch();
        this.scheduler.schedule(Group.INDEX_UPDATING, () -> ((BinaryLatch)updateLatch).release());
        updateLatch.await();
    }
}

