/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextProcedures;
import org.neo4j.kernel.api.impl.fulltext.NullAuxiliaryTransactionStateManager;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;

public class FulltextIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    private static final String KEY = "fulltext";
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("fulltext", "1.0");

    public FulltextIndexProviderFactory() {
        super(ExtensionType.DATABASE, KEY);
    }

    private static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File storeDir) {
        IndexDirectoryStructure parentDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((File)storeDir).forProvider(DESCRIPTOR);
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)parentDirectoryStructure);
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) {
        AuxiliaryTransactionStateManager auxiliaryTransactionStateManager;
        Config config = dependencies.getConfig();
        boolean ephemeral = (Boolean)config.get(GraphDatabaseSettings.ephemeral);
        FileSystemAbstraction fileSystemAbstraction = dependencies.fileSystem();
        DirectoryFactory directoryFactory = DirectoryFactory.directoryFactory((boolean)ephemeral);
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        JobScheduler scheduler = dependencies.scheduler();
        IndexDirectoryStructure.Factory directoryStructureFactory = FulltextIndexProviderFactory.subProviderDirectoryStructure(context.directory());
        TokenHolders tokenHolders = dependencies.tokenHolders();
        Log log = dependencies.getLogService().getInternalLog(FulltextIndexProvider.class);
        try {
            auxiliaryTransactionStateManager = dependencies.auxiliaryTransactionStateManager();
        }
        catch (UnsatisfiedDependencyException e) {
            String message = "Fulltext indexes failed to register as transaction state providers. This means that, if queried, they will not be able to uncommitted transactional changes into account. This is fine if the indexes are opened for non-transactional work, such as for consistency checking. The reason given is: " + e.getMessage();
            this.logDependencyException(context, log.errorLogger(), message);
            auxiliaryTransactionStateManager = new NullAuxiliaryTransactionStateManager();
        }
        FulltextIndexProvider provider = new FulltextIndexProvider(DESCRIPTOR, directoryStructureFactory, fileSystemAbstraction, config, tokenHolders, directoryFactory, operationalMode, scheduler, auxiliaryTransactionStateManager, log);
        String procedureRegistrationFailureMessage = "Failed to register the fulltext index procedures. The fulltext index provider will be loaded and updated like normal, but it might not be possible to query any fulltext indexes. The reason given is: ";
        try {
            dependencies.procedures().registerComponent(FulltextAdapter.class, procContext -> provider, true);
            dependencies.procedures().registerProcedure(FulltextProcedures.class);
        }
        catch (KernelException e) {
            String message = procedureRegistrationFailureMessage + e.getUserMessage((TokenNameLookup)new NonTransactionalTokenNameLookup(tokenHolders));
            this.logDependencyException(context, log.warnLogger(), message);
        }
        catch (UnsatisfiedDependencyException e) {
            String message = procedureRegistrationFailureMessage + e.getMessage();
            this.logDependencyException(context, log.errorLogger(), message);
        }
        return provider;
    }

    private void logDependencyException(KernelContext context, Logger dbmsLog, String message) {
        if (context.databaseInfo() != DatabaseInfo.TOOL) {
            dbmsLog.log(message);
        }
    }

    public static interface Dependencies {
        public Config getConfig();

        public FileSystemAbstraction fileSystem();

        public JobScheduler scheduler();

        public TokenHolders tokenHolders();

        public Procedures procedures();

        public LogService getLogService();

        public AuxiliaryTransactionStateManager auxiliaryTransactionStateManager();
    }
}

