/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Map;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexDropper;
import org.neo4j.values.storable.Value;

class FulltextIndexDropper
implements IndexDropper {
    private final IndexDescriptor index;
    private final DatabaseIndex<FulltextIndexReader> fulltextIndex;
    private final boolean readOnly;

    FulltextIndexDropper(IndexDescriptor index, DatabaseIndex<FulltextIndexReader> fulltextIndex, boolean readOnly) {
        this.index = index;
        this.fulltextIndex = fulltextIndex;
        this.readOnly = readOnly;
    }

    public void drop() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot drop read-only index.");
        }
        this.fulltextIndex.drop();
    }

    public Map<String, Value> indexConfig() {
        return this.index.getIndexConfig().asMap();
    }
}

