/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

class FailedFulltextIndexPopulator
extends IndexPopulator.Adapter {
    private final IndexDescriptor index;
    private final DatabaseIndex<FulltextIndexReader> fulltextIndex;
    private final Exception exception;

    FailedFulltextIndexPopulator(IndexDescriptor index, DatabaseIndex<FulltextIndexReader> fulltextIndex, Exception exception) {
        this.index = index;
        this.fulltextIndex = fulltextIndex;
        this.exception = exception;
    }

    public void create() {
    }

    public void drop() {
        this.fulltextIndex.drop();
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        throw this.failedException();
    }

    private IllegalStateException failedException() {
        return new IllegalStateException("Failed to create index populator.", this.exception);
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new IndexUpdater(){

            public void process(IndexEntryUpdate<?> update) {
                throw FailedFulltextIndexPopulator.this.failedException();
            }

            public void close() {
            }
        };
    }

    public void markAsFailed(String failure) {
        try {
            this.fulltextIndex.markAsFailed(failure);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Map<String, Value> indexConfig() {
        return this.index.getIndexConfig().asMap();
    }
}

