/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.values.storable.ValueCategory;

class FulltextIndexCapability
implements IndexCapability {
    private static final IndexBehaviour[] EVENTUALLY_CONSISTENT_BEHAVIOUR = new IndexBehaviour[]{IndexBehaviour.EVENTUALLY_CONSISTENT, IndexBehaviour.SKIP_AND_LIMIT};
    private static final IndexBehaviour[] NORMAL_BEHAVIOUR = new IndexBehaviour[]{IndexBehaviour.SKIP_AND_LIMIT};
    private final boolean isEventuallyConsistent;

    FulltextIndexCapability(boolean isEventuallyConsistent) {
        this.isEventuallyConsistent = isEventuallyConsistent;
    }

    public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
        return ORDER_NONE;
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        return IndexValueCapability.NO;
    }

    public IndexBehaviour[] behaviours() {
        return this.isEventuallyConsistent ? EVENTUALLY_CONSISTENT_BEHAVIOUR : NORMAL_BEHAVIOUR;
    }
}

