/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.schema.AnalyzerProvider;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexRef;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.impl.fulltext.FailedFulltextIndexPopulator;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexAccessor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexAnalyzerLoader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexBuilder;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexCapability;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexPopulator;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.LuceneMinimalIndexAccessor;
import org.neo4j.kernel.api.impl.index.MinimalDatabaseIndex;
import org.neo4j.kernel.api.impl.index.SchemaIndexMigrator;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class FulltextIndexProvider
extends IndexProvider {
    public static final IndexUpdateIgnoreStrategy UPDATE_IGNORE_STRATEGY = values -> {
        for (Value value : values) {
            if (value == null || value.valueGroup().category() != ValueCategory.TEXT && value.valueGroup().category() != ValueCategory.TEXT_ARRAY) continue;
            return false;
        }
        return true;
    };
    private final FileSystemAbstraction fileSystem;
    private final Config config;
    private final TokenHolders tokenHolders;
    private final String defaultAnalyzerName;
    private final boolean defaultEventuallyConsistentSetting;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final InternalLog log;
    private final IndexUpdateSink indexUpdateSink;
    private final IndexStorageFactory indexStorageFactory;

    public FulltextIndexProvider(IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructureFactory, FileSystemAbstraction fileSystem, Config config, TokenHolders tokenHolders, DirectoryFactory directoryFactory, DatabaseReadOnlyChecker readOnlyChecker, JobScheduler scheduler, InternalLog log) {
        super(descriptor, directoryStructureFactory);
        this.fileSystem = fileSystem;
        this.config = config;
        this.tokenHolders = tokenHolders;
        this.readOnlyChecker = readOnlyChecker;
        this.log = log;
        this.defaultAnalyzerName = (String)config.get(FulltextSettings.fulltext_default_analyzer);
        this.defaultEventuallyConsistentSetting = (Boolean)config.get(FulltextSettings.eventually_consistent);
        this.indexUpdateSink = new IndexUpdateSink(scheduler, (Integer)config.get(FulltextSettings.eventually_consistent_index_update_queue_max_length));
        this.indexStorageFactory = FulltextIndexProvider.buildIndexStorageFactory(fileSystem, directoryFactory, this.directoryStructure());
    }

    private static IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure structure) {
        return new IndexStorageFactory(directoryFactory, fileSystem, structure);
    }

    private PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    public void shutdown() throws Exception {
        this.indexStorageFactory.close();
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        IndexConfig indexConfig = index.getIndexConfig();
        if ((index = index.withIndexConfig(indexConfig = this.addMissingDefaultIndexConfig(indexConfig))).getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability(FulltextIndexProvider.getCapability(index));
        }
        return index;
    }

    private static IndexCapability getCapability(IndexDescriptor index) {
        return new FulltextIndexCapability(FulltextIndexSettings.isEventuallyConsistent(index));
    }

    public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getIndexStorage(descriptor.getId()).getStoredIndexFailure(), (CharSequence)"");
    }

    public InternalIndexState getInitialState(IndexDescriptor index, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(index.getId());
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            this.validateIndexRef((IndexRef<?>)index);
        }
        catch (Exception e) {
            try {
                indexStorage.storeIndexFailure(Exceptions.stringify((Throwable)e));
            }
            catch (IOException ex) {
                ex.addSuppressed(e);
                this.log.warn("Failed to persist index failure. Index failure added as suppressed exception.", (Throwable)ex);
            }
            return InternalIndexState.FAILED;
        }
        try {
            return AbstractLuceneIndexProvider.indexIsOnline((PartitionedIndexStorage)indexStorage, (IndexDescriptor)index, (Config)this.config) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            return InternalIndexState.POPULATING;
        }
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor, boolean forRebuildDuringRecovery) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        MinimalDatabaseIndex index = new MinimalDatabaseIndex(indexStorage, descriptor, this.config);
        this.log.debug("Creating dropper for fulltext schema index: %s", new Object[]{descriptor});
        return new LuceneMinimalIndexAccessor(descriptor, (DatabaseIndex)index, this.isReadOnly());
    }

    private boolean isReadOnly() {
        return this.readOnlyChecker.isReadOnly();
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        try {
            PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
            Analyzer analyzer = FulltextIndexAnalyzerLoader.INSTANCE.createAnalyzer(descriptor, tokenNameLookup);
            String[] propertyNames = FulltextIndexSettings.createPropertyNames(descriptor, tokenNameLookup);
            DatabaseIndex<FulltextIndexReader> fulltextIndex = ((FulltextIndexBuilder)((FulltextIndexBuilder)FulltextIndexBuilder.create(descriptor, this.config, this.readOnlyChecker, this.tokenHolders.propertyKeyTokens(), analyzer, propertyNames).withFileSystem(this.fileSystem)).withIndexStorage(indexStorage)).withPopulatingMode(true).build();
            this.log.debug("Creating populator for fulltext schema index: %s", new Object[]{descriptor});
            return new FulltextIndexPopulator(descriptor, fulltextIndex, propertyNames, UPDATE_IGNORE_STRATEGY);
        }
        catch (Exception e) {
            PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
            MinimalDatabaseIndex index = new MinimalDatabaseIndex(indexStorage, descriptor, this.config);
            this.log.debug("Creating failed index populator for fulltext schema index: %s", new Object[]{descriptor, e});
            return new FailedFulltextIndexPopulator(descriptor, (DatabaseIndex<FulltextIndexReader>)index, e);
        }
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor index, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(index.getId());
        Analyzer analyzer = FulltextIndexAnalyzerLoader.INSTANCE.createAnalyzer(index, (TokenNameLookup)this.tokenHolders);
        String[] propertyNames = FulltextIndexSettings.createPropertyNames(index, (TokenNameLookup)this.tokenHolders);
        FulltextIndexBuilder fulltextIndexBuilder = ((FulltextIndexBuilder)((FulltextIndexBuilder)FulltextIndexBuilder.create(index, this.config, this.readOnlyChecker, this.tokenHolders.propertyKeyTokens(), analyzer, propertyNames).withFileSystem(this.fileSystem)).withIndexStorage(indexStorage)).withPopulatingMode(false);
        if (FulltextIndexSettings.isEventuallyConsistent(index)) {
            fulltextIndexBuilder = fulltextIndexBuilder.withIndexUpdateSink(this.indexUpdateSink);
        }
        if (readOnly) {
            fulltextIndexBuilder = (FulltextIndexBuilder)fulltextIndexBuilder.permanentlyReadOnly();
        }
        DatabaseIndex<FulltextIndexReader> fulltextIndex = fulltextIndexBuilder.build();
        fulltextIndex.open();
        FulltextIndexAccessor accessor = new FulltextIndexAccessor(this.indexUpdateSink, fulltextIndex, index, propertyNames, UPDATE_IGNORE_STRATEGY);
        this.log.debug("Created online accessor for fulltext schema index %s: %s", new Object[]{index, accessor});
        return accessor;
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
        return new SchemaIndexMigrator("Fulltext indexes", fs, pageCache, pageCacheTracer, this.directoryStructure(), storageEngineFactory, contextFactory);
    }

    public void validatePrototype(IndexPrototype prototype) {
        this.validateIndexRef((IndexRef<?>)prototype);
    }

    public IndexType getIndexType() {
        return IndexType.FULLTEXT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateIndexRef(IndexRef<?> ref) {
        String providerName = this.getProviderDescriptor().name();
        if (ref.getIndexType() != IndexType.FULLTEXT) {
            throw new IllegalArgumentException("The '" + providerName + "' index provider only supports FULLTEXT index types: " + ref);
        }
        if (!ref.schema().isFulltextSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + ref.schema() + " index schema is not a full-text index schema, which it is required to be for the '" + providerName + "' index provider to be able to create an index.");
        }
        Value value = ref.getIndexConfig().get(FulltextIndexSettingsKeys.ANALYZER);
        if (value != null) {
            if (value.valueGroup() != ValueGroup.TEXT) throw new IllegalArgumentException("Wrong index setting value type for fulltext analyzer: '" + value + "'.");
            String analyzerName = ((TextValue)value).stringValue();
            Optional<AnalyzerProvider> analyzerProvider = this.listAvailableAnalyzers().filter(analyzer -> analyzer.getName().equals(analyzerName)).findFirst();
            if (!analyzerProvider.isPresent()) throw new IllegalArgumentException("No such full-text analyzer: '" + analyzerName + "'.");
            Analyzer analyzer2 = analyzerProvider.get().createAnalyzer();
            Objects.requireNonNull(analyzer2, "The '" + analyzerName + "' analyzer returned a 'null' analyzer.");
        }
        TokenHolder propertyKeyTokens = this.tokenHolders.propertyKeyTokens();
        for (int propertyId : ref.schema().getPropertyIds()) {
            try {
                NamedToken token = propertyKeyTokens.getTokenById(propertyId);
                if (!token.name().equals("__neo4j__lucene__fulltext__index__internal__id__")) continue;
                throw new IllegalArgumentException("Unable to index the property, the name is reserved for internal use __neo4j__lucene__fulltext__index__internal__id__");
            }
            catch (TokenNotFoundException e) {
                throw new IllegalArgumentException("Schema references non-existing property key token id: " + propertyId + ".", e);
            }
        }
    }

    private IndexConfig addMissingDefaultIndexConfig(IndexConfig indexConfig) {
        indexConfig = indexConfig.withIfAbsent(FulltextIndexSettingsKeys.ANALYZER, (Value)Values.stringValue((String)this.defaultAnalyzerName));
        indexConfig = indexConfig.withIfAbsent(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, (Value)Values.booleanValue((boolean)this.defaultEventuallyConsistentSetting));
        return indexConfig;
    }

    public void awaitRefresh() {
        this.indexUpdateSink.awaitUpdateApplication();
    }

    public Stream<AnalyzerProvider> listAvailableAnalyzers() {
        return Services.loadAll(AnalyzerProvider.class).stream();
    }
}

