/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.neo4j.gqlstatus.CommonGqlStatusObject;
import org.neo4j.gqlstatus.Condition;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfo;

public class CommonGqlStatusObjectImplementation
implements CommonGqlStatusObject,
Serializable {
    protected final GqlStatusInfo gqlStatusInfo;
    protected final DiagnosticRecord diagnosticRecord;
    protected String messageWithParameters;

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord, Object[] messageParameterValues) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = this.insertMessageParameters(messageParameterValues);
    }

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord, Map<GqlParams.GqlParam, Object> messageParameters) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = this.insertMessageParameters(messageParameters);
    }

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = gqlStatusInfo.getMessage(new Object[0]);
    }

    @Override
    public String gqlStatus() {
        return this.gqlStatusInfo.getStatusString();
    }

    @Override
    public String statusDescription() {
        Condition condition = this.gqlStatusInfo.getCondition();
        String subCondition = this.gqlStatusInfo.getSubCondition();
        if (this.messageWithParameters.isEmpty()) {
            return Condition.createStandardDescription(condition, subCondition);
        }
        return Condition.createStandardDescription(condition, subCondition) + ". " + this.messageWithParameters;
    }

    @Override
    public Map<String, Object> diagnosticRecord() {
        return this.diagnosticRecord.asMap();
    }

    protected String insertMessageParameters(Object[] parameterValues) {
        if (this.gqlStatusInfo.parameterCount() != parameterValues.length) {
            Object[] keys = this.gqlStatusInfo.getStatusParameterKeys().stream().map(GqlParams.GqlParam::name).toArray();
            throw new IllegalArgumentException(String.format("Expected parameterKeys: %s and parameterValues: %s to have the same length.", Arrays.toString(keys), Arrays.toString(parameterValues)));
        }
        this.diagnosticRecord.setStatusParameters(this.gqlStatusInfo.parameterMap(parameterValues));
        return this.gqlStatusInfo.getMessage(parameterValues);
    }

    protected String insertMessageParameters(Map<GqlParams.GqlParam, Object> parameters) {
        this.diagnosticRecord.setStatusParameters(this.gqlStatusInfo.parameterMap(parameters));
        return this.gqlStatusInfo.getMessage(parameters);
    }

    public Condition getCondition() {
        return this.gqlStatusInfo.getCondition();
    }

    public void adjustPosition(int oldOffset, int oldLine, int oldColumn, int newOffset, int newLine, int newColumn) {
        Map<String, Integer> positionMap;
        if (this.diagnosticRecord.hasPosition() && (positionMap = this.diagnosticRecord.getPositionMap()).get("offset") == oldOffset && positionMap.get("line") == oldLine && positionMap.get("column") == oldColumn) {
            this.diagnosticRecord.updatePosition(newOffset, newLine, newColumn);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonGqlStatusObjectImplementation that = (CommonGqlStatusObjectImplementation)o;
        return Objects.equals(this.gqlStatusInfo, that.gqlStatusInfo) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord);
    }

    public int hashCode() {
        return Objects.hash(this.gqlStatusInfo, this.diagnosticRecord);
    }
}

