/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

public record GqlStatus(String gqlStatusString) {
    public GqlStatus(String gqlStatusString) {
        this.gqlStatusString = this.validate(gqlStatusString);
    }

    private String validate(String input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("GQLSTATUS must be 5 characters and alphanumeric, got an empty string.");
        }
        if (!input.matches("[A-Za-z0-9]{5}")) {
            throw new IllegalArgumentException(String.format("GQLSTATUS must be 5 characters and alphanumeric, got: %s.", input));
        }
        return input.toUpperCase();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof GqlStatus) {
            GqlStatus otherGqlStatus = (GqlStatus)that;
            return this.gqlStatusString.equals(otherGqlStatus.gqlStatusString);
        }
        return false;
    }
}

