/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.gqlstatus.CommonGqlStatusObject;
import org.neo4j.gqlstatus.Condition;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.GqlStatusInfo;

public class CommonGqlStatusObjectImplementation
implements CommonGqlStatusObject {
    protected final GqlStatusInfo gqlStatusInfo;
    protected final DiagnosticRecord diagnosticRecord;
    protected String messageWithParameters;

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord, Object[] messageParameterValues) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = this.insertMessageParameters(messageParameterValues);
    }

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = gqlStatusInfo.getMessage();
    }

    @Override
    public String gqlStatus() {
        return this.gqlStatusInfo.getStatusString();
    }

    @Override
    public String statusDescription() {
        Condition condition = this.gqlStatusInfo.getCondition();
        String subCondition = this.gqlStatusInfo.getSubCondition();
        if (this.messageWithParameters.isEmpty()) {
            return Condition.createStandardDescription(condition, subCondition);
        }
        return Condition.createStandardDescription(condition, subCondition) + ". " + this.messageWithParameters;
    }

    @Override
    public Map<String, Object> diagnosticRecord() {
        return this.diagnosticRecord.asMap();
    }

    private String insertMessageParameters(Object[] parameterValues) {
        Object[] parameterKeys = this.gqlStatusInfo.getStatusParameterKeys();
        HashMap<String, Object> statusParameters = new HashMap<String, Object>();
        String[] messageParameters = new String[parameterValues.length];
        if (parameterKeys.length != parameterValues.length) {
            throw new IllegalArgumentException(String.format("Expected parameterKeys: %s and parameterValues: %s to have the same length.", Arrays.toString(parameterKeys), Arrays.toString(parameterValues)));
        }
        for (int i = 0; i < parameterKeys.length; ++i) {
            Object key = parameterKeys[i];
            Object value = parameterValues[i];
            if (value instanceof String) {
                String s = (String)value;
                statusParameters.put((String)key, value);
                messageParameters[i] = s;
                continue;
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                statusParameters.put((String)key, value);
                messageParameters[i] = b.toString();
                continue;
            }
            if (value instanceof Integer) {
                Integer nbr = (Integer)value;
                statusParameters.put((String)key, value);
                messageParameters[i] = nbr.toString();
                continue;
            }
            if (this.isListOfString(value)) {
                statusParameters.put((String)key, value);
                messageParameters[i] = String.join((CharSequence)", ", (List)value);
                continue;
            }
            throw new IllegalArgumentException(String.format("Expected parameter to be String, Boolean, Integer or List<String> but was %s", value));
        }
        this.diagnosticRecord.setStatusParameters(statusParameters);
        return String.format(this.gqlStatusInfo.getMessage(), messageParameters);
    }

    private boolean isListOfString(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        for (Object element : list) {
            if (element instanceof String) continue;
            return false;
        }
        return true;
    }

    public Condition getCondition() {
        return this.gqlStatusInfo.getCondition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonGqlStatusObjectImplementation that = (CommonGqlStatusObjectImplementation)o;
        return Objects.equals(this.gqlStatusInfo, that.gqlStatusInfo) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord);
    }

    public int hashCode() {
        return Objects.hash(this.gqlStatusInfo, this.diagnosticRecord);
    }
}

