/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.neo4j.gqlstatus.CommonGqlStatusObject;
import org.neo4j.gqlstatus.Condition;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.GqlMessageParams;
import org.neo4j.gqlstatus.GqlStatusInfo;

public class CommonGqlStatusObjectImplementation
implements CommonGqlStatusObject {
    protected final GqlStatusInfo gqlStatusInfo;
    protected final DiagnosticRecord diagnosticRecord;
    protected String messageWithParameters;

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord, Object[] messageParameterValues) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = this.insertMessageParameters(messageParameterValues);
    }

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord, Map<GqlMessageParams, Object> messageParameters) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = this.insertMessageParameters(messageParameters);
    }

    public CommonGqlStatusObjectImplementation(GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord) {
        this.gqlStatusInfo = gqlStatusInfo;
        this.diagnosticRecord = diagnosticRecord;
        this.messageWithParameters = gqlStatusInfo.getMessage(new Object[0]);
    }

    @Override
    public String gqlStatus() {
        return this.gqlStatusInfo.getStatusString();
    }

    @Override
    public String statusDescription() {
        Condition condition = this.gqlStatusInfo.getCondition();
        String subCondition = this.gqlStatusInfo.getSubCondition();
        if (this.messageWithParameters.isEmpty()) {
            return Condition.createStandardDescription(condition, subCondition);
        }
        return Condition.createStandardDescription(condition, subCondition) + ". " + this.messageWithParameters;
    }

    @Override
    public Map<String, Object> diagnosticRecord() {
        return this.diagnosticRecord.asMap();
    }

    protected String insertMessageParameters(Object[] parameterValues) {
        if (this.gqlStatusInfo.parameterCount() != parameterValues.length) {
            Object[] keys = this.gqlStatusInfo.getStatusParameterKeys().stream().map(Enum::name).toArray();
            throw new IllegalArgumentException(String.format("Expected parameterKeys: %s and parameterValues: %s to have the same length.", Arrays.toString(keys), Arrays.toString(parameterValues)));
        }
        this.diagnosticRecord.setStatusParameters(this.gqlStatusInfo.parameterMap(parameterValues));
        return this.gqlStatusInfo.getMessage(parameterValues);
    }

    protected String insertMessageParameters(Map<GqlMessageParams, Object> parameters) {
        this.diagnosticRecord.setStatusParameters(this.gqlStatusInfo.parameterMap(parameters));
        return this.gqlStatusInfo.getMessage(parameters);
    }

    public Condition getCondition() {
        return this.gqlStatusInfo.getCondition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonGqlStatusObjectImplementation that = (CommonGqlStatusObjectImplementation)o;
        return Objects.equals(this.gqlStatusInfo, that.gqlStatusInfo) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord);
    }

    public int hashCode() {
        return Objects.hash(this.gqlStatusInfo, this.diagnosticRecord);
    }
}

