/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

public enum Condition {
    NO_DATA,
    WARNING,
    SUCCESSFUL_COMPLETION,
    INFORMATIONAL,
    CONNECTION_EXCEPTION,
    DATA_EXCEPTION,
    SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION,
    GENERAL_PROCESSING_EXCEPTION,
    SYSTEM_CONFIGURATION_OR_OPERATION_EXCEPTION,
    PROCEDURE_EXCEPTION,
    DEPENDENT_OBJECT_ERROR,
    GRAPH_TYPE_VIOLATION,
    INVALID_TRANSACTION_STATE,
    INVALID_TRANSACTION_TERMINATION,
    TRANSACTION_ROLLBACK;


    public static String createStandardDescription(Condition condition, String subcondition) {
        return switch (condition) {
            case WARNING -> "warn: " + subcondition;
            case INFORMATIONAL -> "info: " + subcondition;
            case SUCCESSFUL_COMPLETION -> {
                String successBaseMessage = "note: successful completion";
                if (subcondition.isEmpty()) {
                    yield successBaseMessage;
                }
                yield successBaseMessage + " - " + subcondition;
            }
            case NO_DATA -> {
                String successBaseMessage = "note: no data";
                if (subcondition.isEmpty()) {
                    yield successBaseMessage;
                }
                yield successBaseMessage + " - " + subcondition;
            }
            default -> {
                String exceptionBaseMessage = "error: " + condition.createConditionString();
                if (subcondition.isEmpty()) {
                    yield exceptionBaseMessage;
                }
                yield exceptionBaseMessage + " - " + subcondition;
            }
        };
    }

    private String createConditionString() {
        return this.name().toLowerCase().replace('_', ' ');
    }
}

