/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.gqlstatus.CommonGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfo;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class ErrorGqlStatusObjectImplementation
extends CommonGqlStatusObjectImplementation
implements ErrorGqlStatusObject {
    private final Optional<ErrorGqlStatusObject> cause;
    private final Map<GqlParams.GqlParam, Object> paramMap;
    private final GqlStatusInfoCodes gqlStatusInfoCode;

    private ErrorGqlStatusObjectImplementation(GqlStatusInfoCodes gqlStatusInfoCode, Map<GqlParams.GqlParam, Object> parameters, ErrorGqlStatusObject cause, DiagnosticRecord diagnosticRecord) {
        super((GqlStatusInfo)gqlStatusInfoCode, diagnosticRecord, parameters);
        this.gqlStatusInfoCode = gqlStatusInfoCode;
        this.cause = Optional.ofNullable(cause);
        this.paramMap = Map.copyOf(parameters);
    }

    public static Builder from(GqlStatusInfoCodes gqlStatusInfo) {
        return new Builder(gqlStatusInfo);
    }

    @Override
    public Optional<ErrorGqlStatusObject> cause() {
        return this.cause;
    }

    @Override
    public ErrorGqlStatusObject gqlStatusObject() {
        return this;
    }

    public ErrorGqlStatusObject copyWithCause(ErrorGqlStatusObject cause) {
        return new Builder(this.gqlStatusInfoCode).withParamMap(this.paramMap).withCause(cause).build();
    }

    @Override
    public String legacyMessage() {
        return "";
    }

    public String toString() {
        return this.recToString();
    }

    private String recToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Status: ");
        sb.append(this.gqlStatusInfoCode.getStatusString().trim());
        sb.append("\n");
        sb.append("Message: ");
        sb.append(this.insertMessageParameters(this.paramMap).trim());
        sb.append("\n");
        sb.append("Subcondition: ");
        sb.append(this.gqlStatusInfoCode.getSubCondition().trim());
        if (this.cause.isPresent()) {
            sb.append("\n");
            sb.append("Caused by:");
            return sb.append(ErrorGqlStatusObjectImplementation.indent(4, this.cause.get().toString())).toString();
        }
        return sb.toString();
    }

    public static String indent(int n, String input) {
        String indent = " ".repeat(n);
        String[] lines = input.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(indent).append(line).append("\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static class Builder {
        private ErrorGqlStatusObject cause = null;
        private Map<GqlParams.GqlParam, Object> paramMap = new HashMap<GqlParams.GqlParam, Object>();
        private final GqlStatusInfoCodes gqlStatusInfoCode;
        private final DiagnosticRecord.Builder diagnosticRecordBuilder = DiagnosticRecord.from();

        private Builder(GqlStatusInfoCodes gqlStatusInfo) {
            this.gqlStatusInfoCode = gqlStatusInfo;
        }

        public Builder withParam(GqlParams.StringParam param, String value) {
            this.paramMap.put(param, value);
            return this;
        }

        public Builder withParam(GqlParams.BooleanParam param, boolean value) {
            this.paramMap.put(param, value);
            return this;
        }

        public Builder withParam(GqlParams.NumberParam param, Number value) {
            this.paramMap.put(param, value);
            return this;
        }

        public Builder withParam(GqlParams.ListParam param, List<?> value) {
            this.paramMap.put(param, value);
            return this;
        }

        Builder withParamMap(Map<GqlParams.GqlParam, Object> paramMap) {
            this.paramMap = paramMap;
            return this;
        }

        public Builder withCause(ErrorGqlStatusObject cause) {
            this.cause = cause;
            return this;
        }

        public Builder withClassification(GqlClassification classification) {
            this.diagnosticRecordBuilder.withClassification(classification);
            return this;
        }

        public Builder atPosition(int line, int col, int offset) {
            this.diagnosticRecordBuilder.atPosition(line, col, offset);
            return this;
        }

        public ErrorGqlStatusObject build() {
            DiagnosticRecord diagnosticRecord = this.diagnosticRecordBuilder.build();
            return new ErrorGqlStatusObjectImplementation(this.gqlStatusInfoCode, this.paramMap, this.cause, diagnosticRecord);
        }
    }
}

