/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphalgo.impl.util.WeightedPathImpl;
import org.neo4j.graphdb.Path;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class WeightedPathIterator
extends PrefetchingIterator<WeightedPath> {
    private final Iterator<Path> paths;
    private final CostEvaluator<Double> costEvaluator;
    private Double foundWeight;
    private int foundTotal;
    private final double epsilon;
    private final PathInterest interest;

    public WeightedPathIterator(Iterator<Path> paths, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestWeight) {
        this(paths, costEvaluator, NoneStrictMath.EPSILON, stopAfterLowestWeight);
    }

    public WeightedPathIterator(Iterator<Path> paths, CostEvaluator<Double> costEvaluator, double epsilon, boolean stopAfterLowestWeight) {
        this(paths, costEvaluator, epsilon, stopAfterLowestWeight ? PathInterestFactory.allShortest(epsilon) : PathInterestFactory.all(epsilon));
    }

    public WeightedPathIterator(Iterator<Path> paths, CostEvaluator<Double> costEvaluator, double epsilon, PathInterest interest) {
        this.paths = paths;
        this.costEvaluator = costEvaluator;
        this.epsilon = epsilon;
        this.interest = interest;
    }

    protected WeightedPath fetchNextOrNull() {
        if (!this.interest.stillInteresting(++this.foundTotal)) {
            return null;
        }
        if (!this.paths.hasNext()) {
            return null;
        }
        WeightedPathImpl path = new WeightedPathImpl(this.costEvaluator, this.paths.next());
        if (this.interest.stopAfterLowestCost() && this.foundWeight != null && NoneStrictMath.compare((double)path.weight(), (double)this.foundWeight, (double)this.epsilon) > 0) {
            return null;
        }
        this.foundWeight = path.weight();
        return path;
    }
}

