/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Collections;
import java.util.Iterator;
import org.neo4j.function.Predicate;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.DijkstraBranchCollisionDetector;
import org.neo4j.graphalgo.impl.util.DijkstraSelectorFactory;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphalgo.impl.util.TopFetchingWeightedPathIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.BranchCollisionDetector;
import org.neo4j.graphdb.traversal.BranchCollisionPolicy;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.util.MutableDouble;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class DijkstraBidirectional
implements PathFinder<WeightedPath> {
    private final PathExpander expander;
    private final InitialBranchState stateFactory;
    private final CostEvaluator<Double> costEvaluator;
    private final double epsilon;
    private Traverser lastTraverser;

    public DijkstraBidirectional(RelationshipExpander expander, CostEvaluator<Double> costEvaluator) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), costEvaluator);
    }

    public DijkstraBidirectional(PathExpander expander, CostEvaluator<Double> costEvaluator) {
        this(expander, costEvaluator, NoneStrictMath.EPSILON);
    }

    public DijkstraBidirectional(PathExpander expander, CostEvaluator<Double> costEvaluator, double epsilon) {
        this.expander = expander;
        this.costEvaluator = costEvaluator;
        this.epsilon = epsilon;
        this.stateFactory = InitialBranchState.DOUBLE_ZERO;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        final Traverser traverser = this.traverser(start, end, PathInterestFactory.allShortest(this.epsilon));
        return new Iterable<WeightedPath>(){

            @Override
            public Iterator<WeightedPath> iterator() {
                return new TopFetchingWeightedPathIterator((Iterator<Path>)traverser.iterator(), DijkstraBidirectional.this.costEvaluator);
            }
        };
    }

    private Traverser traverser(Node start, Node end, PathInterest interest) {
        TraversalDescription side;
        final MutableDouble shortestSoFar = new MutableDouble(Double.MAX_VALUE);
        MutableDouble startSideShortest = new MutableDouble(0.0);
        MutableDouble endSideShortest = new MutableDouble(0.0);
        DijkstraBidirectionalPathExpander dijkstraExpander = new DijkstraBidirectionalPathExpander(this.expander, shortestSoFar, true, startSideShortest, endSideShortest, this.epsilon);
        TraversalDescription startSide = side = Traversal.traversal().expand((PathExpander)dijkstraExpander, this.stateFactory).order((BranchOrderingPolicy)new DijkstraSelectorFactory(interest, this.costEvaluator)).evaluator((PathEvaluator)new DijkstraBidirectionalEvaluator(this.costEvaluator)).uniqueness((UniquenessFactory)Uniqueness.NODE_PATH);
        TraversalDescription endSide = side.reverse();
        BidirectionalTraversalDescription traversal = Traversal.bidirectionalTraversal().startSide(startSide).endSide(endSide).collisionEvaluator(Evaluators.all()).collisionPolicy((BranchCollisionPolicy)new BranchCollisionPolicy.CollisionPolicyAdapter(){

            public BranchCollisionDetector create(Evaluator evaluator, Predicate<Path> pathPredicate) {
                return new DijkstraBranchCollisionDetector(evaluator, DijkstraBidirectional.this.costEvaluator, shortestSoFar, DijkstraBidirectional.this.epsilon, pathPredicate);
            }
        });
        this.lastTraverser = traversal.traverse(start, end);
        return this.lastTraverser;
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return (WeightedPath)IteratorUtil.firstOrNull((Iterator)((Object)new TopFetchingWeightedPathIterator((Iterator<Path>)this.traverser(start, end, PathInterestFactory.single(this.epsilon)).iterator(), this.costEvaluator)));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private static class DijkstraBidirectionalEvaluator
    extends PathEvaluator.Adapter<Double> {
        private final CostEvaluator<Double> costEvaluator;

        DijkstraBidirectionalEvaluator(CostEvaluator<Double> costEvaluator) {
            this.costEvaluator = costEvaluator;
        }

        public Evaluation evaluate(Path path, BranchState<Double> state) {
            double nextState = (Double)state.getState();
            if (path.length() > 0) {
                state.setState((Object)(nextState += this.costEvaluator.getCost(path.lastRelationship(), Direction.OUTGOING).doubleValue()));
            }
            return Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }

    private static class DijkstraBidirectionalPathExpander
    implements PathExpander<Double> {
        private final PathExpander source;
        private final MutableDouble shortestSoFar;
        private final MutableDouble otherSideShortest;
        private final double epsilon;
        private final MutableDouble thisSideShortest;
        private final boolean stopAfterLowestCost;

        DijkstraBidirectionalPathExpander(PathExpander source, MutableDouble shortestSoFar, boolean stopAfterLowestCost, MutableDouble thisSideShortest, MutableDouble otherSideShortest, double epsilon) {
            this.source = source;
            this.shortestSoFar = shortestSoFar;
            this.stopAfterLowestCost = stopAfterLowestCost;
            this.thisSideShortest = thisSideShortest;
            this.otherSideShortest = otherSideShortest;
            this.epsilon = epsilon;
        }

        public Iterable<Relationship> expand(Path path, BranchState<Double> state) {
            double thisState;
            this.thisSideShortest.value = thisState = ((Double)state.getState()).doubleValue();
            if (NoneStrictMath.compare((double)(thisState + this.otherSideShortest.value), (double)this.shortestSoFar.value, (double)this.epsilon) > 0 && this.stopAfterLowestCost) {
                return Collections.emptyList();
            }
            return this.source.expand(path, state);
        }

        public PathExpander<Double> reverse() {
            return new DijkstraBidirectionalPathExpander(this.source.reverse(), this.shortestSoFar, this.stopAfterLowestCost, this.otherSideShortest, this.thisSideShortest, this.epsilon);
        }
    }
}

