/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class BetweennessCentrality<ShortestPathCostType>
extends ShortestPathBasedCentrality<Double, ShortestPathCostType> {
    protected Double globalFactor;

    public BetweennessCentrality(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, Set<Node> nodeSet) {
        super(singleSourceShortestPath, new DoubleAdder(), 0.0, nodeSet);
    }

    @Override
    public void reset() {
        super.reset();
        this.globalFactor = 1.0;
        if (this.singleSourceShortestPath.getDirection().equals((Object)Direction.BOTH)) {
            this.globalFactor = 0.5;
        }
    }

    protected Double getAndUpdateNodeDependency(Node node, boolean skipFirstNode, Map<Node, List<Relationship>> successors, Util.PathCounter counter, Map<Node, Double> dependencies) {
        Double dependency = dependencies.get(node);
        if (dependency != null) {
            return dependency;
        }
        dependency = 0.0;
        List<Relationship> succs = successors.get(node);
        if (succs == null || succs.size() == 0) {
            return 0.0;
        }
        for (Relationship relationship : succs) {
            Node otherNode = relationship.getOtherNode(node);
            Double otherDependency = this.getAndUpdateNodeDependency(otherNode, false, successors, counter, dependencies);
            dependency = dependency + (otherDependency + 1.0) * (double)counter.getNumberOfPathsToNode(node) / (double)counter.getNumberOfPathsToNode(otherNode);
        }
        if (!skipFirstNode) {
            dependencies.put(node, dependency);
            this.addCentralityToNode(node, dependency * this.globalFactor);
        }
        return dependency;
    }

    @Override
    public void processShortestPaths(Node node, SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath) {
        Map<Node, List<Relationship>> predecessors = singleSourceShortestPath.getPredecessors();
        Map<Node, List<Relationship>> successors = Util.reversedPredecessors(predecessors);
        Util.PathCounter counter = new Util.PathCounter(predecessors);
        this.getAndUpdateNodeDependency(node, true, successors, counter, new HashMap<Node, Double>());
    }
}

