/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class WeightedPathImpl
implements WeightedPath {
    private final Path path;
    private final double weight;

    public WeightedPathImpl(CostEvaluator<Double> costEvaluator, Path path) {
        this.path = path;
        double cost = 0.0;
        for (Relationship relationship : path.relationships()) {
            cost += costEvaluator.getCost(relationship, Direction.OUTGOING).doubleValue();
        }
        this.weight = cost;
    }

    public WeightedPathImpl(double weight, Path path) {
        this.path = path;
        this.weight = weight;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    public Node startNode() {
        return this.path.startNode();
    }

    public Node endNode() {
        return this.path.endNode();
    }

    public Relationship lastRelationship() {
        return this.path.lastRelationship();
    }

    public int length() {
        return this.path.length();
    }

    public Iterable<Node> nodes() {
        return this.path.nodes();
    }

    public Iterable<Node> reverseNodes() {
        return this.path.reverseNodes();
    }

    public Iterable<Relationship> relationships() {
        return this.path.relationships();
    }

    public Iterable<Relationship> reverseRelationships() {
        return this.path.reverseRelationships();
    }

    public String toString() {
        return this.path.toString() + " weight:" + this.weight;
    }

    public Iterator<Entity> iterator() {
        return this.path.iterator();
    }
}

