/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import org.neo4j.collections.graphdb.BinaryEdge;
import org.neo4j.collections.graphdb.BinaryEdgeType;
import org.neo4j.collections.graphdb.ConnectorDescription;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.ConnectorTypeDescription;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.Edge;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.PropertyType;
import org.neo4j.collections.graphdb.SortableBinaryEdgeType;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.BinaryEdgeImpl;
import org.neo4j.collections.graphdb.impl.BinaryEdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.EdgeImpl;
import org.neo4j.collections.graphdb.impl.EdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.NodeIterable;
import org.neo4j.collections.graphdb.impl.RelationshipTypeIterable;
import org.neo4j.collections.graphdb.impl.SortableBinaryEdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.VertexImpl;
import org.neo4j.collections.graphdb.impl.VertexTypeImpl;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;

public class GraphDatabaseImpl
implements DatabaseService {
    public static String EDGE_TYPE = "org.neo4j.collections.graphdb.edge_type";
    private final GraphDatabaseService graphDb;

    GraphDatabaseImpl(GraphDatabaseService graphDb) {
        this.graphDb = graphDb;
    }

    public Transaction beginTx() {
        return this.getGraphDatabaseService().beginTx();
    }

    @Override
    public Edge createEdge(EdgeType edgeType, ConnectorDescription ... edgeElements) {
        if (edgeElements.length != edgeType.getConnectorTypes().size()) {
            throw new RuntimeException("Number of edge elements provided (" + edgeElements.length + ") is different from the number of edge roles required (" + edgeType.getConnectorTypes().size() + ")");
        }
        for (ConnectorType<?> connector : edgeType.getConnectorTypes()) {
            boolean found = false;
            for (ConnectorDescription relement : edgeElements) {
                if (!relement.getConnectorType().getName().equals(connector.getName())) continue;
                found = true;
            }
            if (found) continue;
            throw new RuntimeException("To create relationship an element with role " + connector.getName() + " should be provide");
        }
        Node n = this.graphDb.createNode();
        n.setProperty(EDGE_TYPE, (Object)edgeType.getNode().getId());
        for (ConnectorDescription relement : edgeElements) {
            for (Vertex elem : relement.getVertices()) {
                n.createRelationshipTo(elem.getNode(), (RelationshipType)DynamicRelationshipType.withName((String)(edgeType.getName() + "/#/" + relement.getConnectorType().getName())));
            }
        }
        return new EdgeImpl(this, n.getId());
    }

    @Override
    public EdgeType createEdgeType(String name, ConnectorTypeDescription ... connectorTypeDescriptions) {
        return EdgeTypeImpl.getOrCreateInstance(this, name, connectorTypeDescriptions);
    }

    public Node createNode() {
        return this.graphDb.createNode();
    }

    @Override
    public Vertex createVertex() {
        return new VertexImpl(this, this.getGraphDatabaseService().createNode().getId());
    }

    public Iterable<Node> getAllNodes() {
        return this.graphDb.getAllNodes();
    }

    @Override
    public Iterable<Vertex> getAllVertices() {
        return new NodeIterable(this.getGraphDatabaseService().getAllNodes());
    }

    @Override
    public BinaryEdge getBinaryEdgeById(long id) {
        return new BinaryEdgeImpl(this, id);
    }

    @Override
    public BinaryEdgeType getBinaryEdgeType(RelationshipType relType) {
        return BinaryEdgeTypeImpl.getOrCreateInstance((DatabaseService)this, relType);
    }

    @Override
    public BinaryEdgeType getBinaryEdgeType(RelationshipType relType, VertexType domain, VertexType range) {
        return BinaryEdgeTypeImpl.getOrCreateInstance((DatabaseService)this, relType, domain, range);
    }

    @Override
    public PropertyType<Boolean[]> getBooleanArrayPropertyType(String name) {
        return PropertyType.BooleanArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType<Boolean> getBooleanPropertyType(String name) {
        return PropertyType.BooleanPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType<Byte[]> getByteArrayPropertyType(String name) {
        return PropertyType.ByteArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType.ComparablePropertyType<Byte> getBytePropertyType(String name) {
        return PropertyType.BytePropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType<Double[]> getDoubleArrayPropertyType(String name) {
        return PropertyType.DoubleArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType.ComparablePropertyType<Double> getDoublePropertyType(String name) {
        return PropertyType.DoublePropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public Iterable<EdgeType> getEdgeTypes() {
        return new RelationshipTypeIterable(this.graphDb.getRelationshipTypes(), this);
    }

    @Override
    public PropertyType<Float[]> getFloatArrayPropertyType(String name) {
        return PropertyType.FloatArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType.ComparablePropertyType<Float> getFloatPropertyType(String name) {
        return PropertyType.FloatPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDb;
    }

    @Override
    public PropertyType<Long[]> getLongArrayPropertyType(String name) {
        return PropertyType.LongArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType.ComparablePropertyType<Long> getLongPropertyType(String name) {
        return PropertyType.LongPropertyType.getOrCreateInstance(this, name);
    }

    public Node getNodeById(long id) {
        return this.graphDb.getNodeById(id);
    }

    public Node getReferenceNode() {
        return this.graphDb.getReferenceNode();
    }

    @Override
    public Vertex getReferenceVertex() {
        return new VertexImpl(this, this.getGraphDatabaseService().getReferenceNode().getId());
    }

    public Relationship getRelationshipById(long id) {
        return this.graphDb.getRelationshipById(id);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.graphDb.getRelationshipTypes();
    }

    @Override
    public VertexType getRootType() {
        return VertexTypeImpl.getOrCreateInstance(this, "Thing");
    }

    @Override
    public PropertyType<Short[]> getShortArrayPropertyType(String name) {
        return PropertyType.ShortArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType.ComparablePropertyType<Short> getShortPropertyType(String name) {
        return PropertyType.ShortPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public <T> SortableBinaryEdgeType<T> getSortableRelationshipType(String name, PropertyType.ComparablePropertyType<T> propertyType) {
        return SortableBinaryEdgeTypeImpl.getOrCreateInstance((DatabaseService)this, (RelationshipType)DynamicRelationshipType.withName((String)name), propertyType);
    }

    @Override
    public PropertyType<String[]> getStringArrayPropertyType(String name) {
        return PropertyType.StringArrayPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public PropertyType.ComparablePropertyType<String> getStringPropertyType(String name) {
        return PropertyType.StringPropertyType.getOrCreateInstance(this, name);
    }

    @Override
    public Vertex getVertex(Node node) {
        if (node.hasProperty(VertexTypeImpl.CLASS_NAME)) {
            try {
                Class<?> claz = Class.forName((String)node.getProperty(VertexTypeImpl.CLASS_NAME));
                Class<?> dbclaz = Class.forName("org.neo4j.collections.graphdb.DatabaseService");
                Class<?> idclaz = Class.forName("java.lang.Long");
                return (Vertex)claz.getConstructor(dbclaz, idclaz).newInstance(this, node.getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (node.hasProperty(BinaryEdgeImpl.REL_ID)) {
            return new BinaryEdgeImpl(this, this.graphDb.getRelationshipById(((Long)node.getProperty(BinaryEdgeImpl.REL_ID)).longValue()).getId());
        }
        return new VertexImpl(this, node.getId());
    }

    public IndexManager index() {
        return this.graphDb.index();
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler arg0) {
        return this.graphDb.registerKernelEventHandler(arg0);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> arg0) {
        return this.graphDb.registerTransactionEventHandler(arg0);
    }

    public void shutdown() {
        this.graphDb.shutdown();
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler arg0) {
        return this.graphDb.unregisterKernelEventHandler(arg0);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> arg0) {
        return this.graphDb.unregisterTransactionEventHandler(arg0);
    }
}

