/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.PropertyType;
import org.neo4j.collections.graphdb.SortableBinaryEdge;
import org.neo4j.collections.graphdb.SortableBinaryEdgeType;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.impl.BinaryEdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.SortableBinaryEdgeImpl;
import org.neo4j.collections.graphdb.impl.VertexTypeImpl;
import org.neo4j.collections.indexedrelationship.IndexedRelationship;
import org.neo4j.collections.sortedtree.PropertySortedTree;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class SortableBinaryEdgeTypeImpl<T>
extends BinaryEdgeTypeImpl
implements SortableBinaryEdgeType<T> {
    public static String PROPERTY_TYPE = "org.neo4j.collections.graphdb.property_type";

    public SortableBinaryEdgeTypeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    protected static Class<?> getImplementationClass() {
        try {
            return Class.forName("org.neo4j.collections.graphdb.impl.SortableBinaryEdgeTypeImpl");
        }
        catch (ClassNotFoundException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static <T> SortableBinaryEdgeType<T> getOrCreateInstance(DatabaseService db, RelationshipType relType, PropertyType.ComparablePropertyType<T> propertyType) {
        VertexTypeImpl vertexType = new VertexTypeImpl(db, SortableBinaryEdgeTypeImpl.getOrCreateByDescriptor(new SortableTypeNodeDescriptor<T>(db, relType.name(), SortableBinaryEdgeTypeImpl.getImplementationClass(), propertyType)).getId());
        return new SortableBinaryEdgeTypeImpl<T>(db, vertexType.getNode().getId());
    }

    @Override
    public PropertyType.ComparablePropertyType<T> getPropertyType() {
        return (PropertyType.ComparablePropertyType)SortableBinaryEdgeTypeImpl.getByName(this.getDb(), (String)this.getNode().getProperty(PROPERTY_TYPE));
    }

    @Override
    public SortableBinaryEdge<T> createEdge(Vertex startVertex, Vertex endVertex) {
        IndexedRelationship idxRel = new IndexedRelationship(startVertex.getNode(), (RelationshipType)DynamicRelationshipType.withName((String)this.getName()), Direction.OUTGOING);
        if (!idxRel.exists()) {
            PropertySortedTree<T> propertySortedTree = new PropertySortedTree<T>(this.getDb().getGraphDatabaseService(), this.getPropertyType(), true, this.getName());
            idxRel.create(propertySortedTree);
        }
        Relationship rel = idxRel.createRelationshipTo(endVertex.getNode());
        return new SortableBinaryEdgeImpl(this.db, rel.getId(), idxRel);
    }

    public static class SortableTypeNodeDescriptor<T>
    extends VertexTypeImpl.TypeNodeDescriptor {
        public final PropertyType.ComparablePropertyType<T> propertyType;

        SortableTypeNodeDescriptor(DatabaseService db, String name, Class<?> claz, PropertyType.ComparablePropertyType<T> propertyType) {
            super(db, name, claz);
            this.propertyType = propertyType;
        }

        @Override
        public void initialize(Node n) {
            super.initialize(n);
            n.setProperty(PROPERTY_TYPE, (Object)this.propertyType.getName());
        }
    }
}

