/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections;

import java.lang.reflect.Constructor;
import org.neo4j.collections.NodeCollection;
import org.neo4j.graphdb.Node;

public class NodeCollectionLoader {
    public static NodeCollection load(Node baseNode) {
        String className = (String)baseNode.getProperty("graph_collection_class", null);
        if (className != null) {
            try {
                Class<?> nodeCollectionClass = Class.forName(className);
                Constructor<?> constructor = nodeCollectionClass.getConstructor(Node.class);
                return (NodeCollection)constructor.newInstance(baseNode);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load node collection", e);
            }
        }
        return null;
    }
}

