/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.btree;

import java.util.Iterator;
import org.neo4j.collections.btree.KeyEntry;
import org.neo4j.collections.btree.TreeNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;

public abstract class AbstractBTree {
    private GraphDatabaseService graphDb;
    private TreeNode treeRoot;

    protected TreeNode getTreeRoot() {
        return this.treeRoot;
    }

    public AbstractBTree(GraphDatabaseService graphDb, Node rootNode) {
        this.graphDb = graphDb;
        this.treeRoot = new TreeNode(this, rootNode);
    }

    void makeRoot(TreeNode newRoot) {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        Node startNode = rel.getStartNode();
        rel.delete();
        startNode.createRelationshipTo(newRoot.getUnderlyingNode(), (RelationshipType)RelTypes.TREE_ROOT);
        this.treeRoot = newRoot;
    }

    public void delete() {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        this.treeRoot.delete();
        rel.delete();
    }

    public void delete(int commitInterval) {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        this.treeRoot.delete(commitInterval, 0);
        rel.delete();
    }

    public void validateTree() {
        TreeNode subTree;
        long currentValue = Long.MIN_VALUE;
        KeyEntry entry = null;
        boolean hasSubTree = false;
        int entryCount = 0;
        for (KeyEntry keyEntry = this.treeRoot.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            entry = keyEntry;
            ++entryCount;
            if (entry.getKey() <= currentValue) {
                throw new RuntimeException("Key entry ordering inconsistency");
            }
            currentValue = entry.getKey();
            subTree = entry.getBeforeSubTree();
            if (subTree != null) {
                hasSubTree = true;
                this.validateAllLessThan(subTree, currentValue);
                continue;
            }
            if (!hasSubTree) continue;
            throw new RuntimeException("Leaf/no leaf inconsistency");
        }
        if (entryCount >= this.getOrder()) {
            throw new RuntimeException("To many entries");
        }
        if (hasSubTree) {
            subTree = entry.getAfterSubTree();
            if (subTree == null) {
                throw new RuntimeException("Leaf/no leaf inconsistency");
            }
            this.validateAllGreaterThan(subTree, currentValue);
        }
    }

    private void validateAllLessThan(TreeNode treeNode, long value) {
        TreeNode subTree;
        long currentValue = Long.MIN_VALUE;
        KeyEntry entry = null;
        boolean hasSubTree = false;
        int entryCount = 0;
        for (KeyEntry keyEntry = treeNode.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            ++entryCount;
            entry = keyEntry;
            if (entry.getKey() >= value) {
                throw new RuntimeException("Depth key inconsistency");
            }
            if (entry.getKey() <= currentValue) {
                throw new RuntimeException("Key entry ordering inconsistency");
            }
            currentValue = entry.getKey();
            subTree = entry.getBeforeSubTree();
            if (subTree != null) {
                hasSubTree = true;
                this.validateAllLessThan(subTree, currentValue);
                continue;
            }
            if (!hasSubTree) continue;
            throw new RuntimeException("Leaf/no leaf inconsistency");
        }
        if (entryCount < this.getOrder() / 2 - 1) {
            throw new RuntimeException("To few entries");
        }
        if (entryCount >= this.getOrder()) {
            throw new RuntimeException("To many entries");
        }
        if (hasSubTree) {
            subTree = entry.getAfterSubTree();
            if (subTree == null) {
                throw new RuntimeException("Leaf/no leaf inconsistency");
            }
            this.validateAllGreaterThan(subTree, currentValue);
        }
    }

    private void validateAllGreaterThan(TreeNode treeNode, long value) {
        TreeNode subTree;
        long currentValue = Long.MIN_VALUE;
        KeyEntry entry = null;
        boolean hasSubTree = false;
        int entryCount = 0;
        for (KeyEntry keyEntry = treeNode.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            ++entryCount;
            entry = keyEntry;
            if (entry.getKey() <= value) {
                throw new RuntimeException("Depth key inconsistency");
            }
            if (entry.getKey() <= currentValue) {
                throw new RuntimeException("Key entry ordering inconsistency");
            }
            currentValue = entry.getKey();
            subTree = entry.getBeforeSubTree();
            if (subTree != null) {
                hasSubTree = true;
                this.validateAllLessThan(subTree, currentValue);
                continue;
            }
            if (!hasSubTree) continue;
            throw new RuntimeException("Leaf/no leaf inconsistency");
        }
        if (entryCount < this.getOrder() / 2 - 1) {
            throw new RuntimeException("To few entries");
        }
        if (entryCount >= this.getOrder()) {
            throw new RuntimeException("To many entries");
        }
        if (hasSubTree) {
            subTree = entry.getAfterSubTree();
            if (subTree == null) {
                throw new RuntimeException("Leaf/no leaf inconsistency");
            }
            this.validateAllGreaterThan(subTree, currentValue);
        }
    }

    public KeyEntry getAsKeyEntry(long key) {
        return this.treeRoot.getEntry(key);
    }

    public Object removeEntry(long key) {
        return this.treeRoot.removeEntry(key);
    }

    int getOrder() {
        return 9;
    }

    GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    public Iterable<KeyEntry> entries() {
        EntryReturnableEvaluator entryEvaluator = new EntryReturnableEvaluator();
        Traverser trav = this.treeRoot.getUnderlyingNode().traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, (ReturnableEvaluator)entryEvaluator, (RelationshipType)RelTypes.KEY_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.SUB_TREE, Direction.OUTGOING);
        return new EntryTraverser(trav, this, entryEvaluator);
    }

    private static class EntryReturnableEvaluator
    implements ReturnableEvaluator {
        private Node currentTreeNode = null;

        private EntryReturnableEvaluator() {
        }

        public Node getCurrentTreeNode() {
            return this.currentTreeNode;
        }

        public boolean isReturnableNode(TraversalPosition pos) {
            if (!pos.notStartNode()) {
                this.currentTreeNode = pos.currentNode();
                return false;
            }
            Relationship last = pos.lastRelationshipTraversed();
            if (last.isType((RelationshipType)RelTypes.KEY_ENTRY)) {
                return true;
            }
            if (last.isType((RelationshipType)RelTypes.SUB_TREE)) {
                this.currentTreeNode = pos.currentNode();
            }
            return false;
        }
    }

    private static class EntryTraverser
    implements Iterable<KeyEntry>,
    Iterator<KeyEntry> {
        private EntryReturnableEvaluator entryEvaluator;
        private AbstractBTree bTree;
        private Iterator<Node> itr;

        EntryTraverser(Traverser trav, AbstractBTree tree, EntryReturnableEvaluator entry) {
            this.itr = trav.iterator();
            this.bTree = tree;
            this.entryEvaluator = entry;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public KeyEntry next() {
            Node node = this.itr.next();
            TreeNode treeNode = new TreeNode(this.bTree, this.entryEvaluator.getCurrentTreeNode());
            return new KeyEntry(treeNode, node.getSingleRelationship((RelationshipType)RelTypes.KEY_ENTRY, Direction.INCOMING));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<KeyEntry> iterator() {
            return this;
        }
    }

    public static enum RelTypes implements RelationshipType
    {
        TREE_ROOT,
        SUB_TREE,
        KEY_ENTRY;

    }
}

